/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpRequestDecorator;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ClientHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class WiretapConnector
implements ClientHttpConnector {
    private static final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final ClientHttpConnector delegate;
    private final Map<String, Info> exchanges = new ConcurrentHashMap<String, Info>();

    WiretapConnector(ClientHttpConnector delegate) {
        this.delegate = delegate;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference requestRef = new AtomicReference();
        return this.delegate.connect(method, uri, request -> {
            WiretapClientHttpRequest wrapped = new WiretapClientHttpRequest((ClientHttpRequest)request);
            requestRef.set(wrapped);
            return (Mono)requestCallback.apply(wrapped);
        }).map(response -> {
            WiretapClientHttpRequest wrappedRequest = (WiretapClientHttpRequest)requestRef.get();
            String header = "WebTestClient-Request-Id";
            String requestId = wrappedRequest.getHeaders().getFirst(header);
            Assert.state(requestId != null, () -> "No \"" + header + "\" header");
            WiretapClientHttpResponse wrappedResponse = new WiretapClientHttpResponse((ClientHttpResponse)response);
            this.exchanges.put(requestId, new Info(wrappedRequest, wrappedResponse));
            return wrappedResponse;
        });
    }

    public Info claimRequest(String requestId) {
        Info info = this.exchanges.remove(requestId);
        Assert.state(info != null, () -> {
            String header = "WebTestClient-Request-Id";
            return "No match for " + header + "=" + requestId;
        });
        return info;
    }

    private static class WiretapClientHttpResponse
    extends ClientHttpResponseDecorator {
        private final DataBuffer buffer;
        private final MonoProcessor<byte[]> body = MonoProcessor.create();

        public WiretapClientHttpResponse(ClientHttpResponse delegate) {
            super(delegate);
            this.buffer = bufferFactory.allocateBuffer();
        }

        public MonoProcessor<byte[]> getContent() {
            return this.body;
        }

        @Override
        public Flux<DataBuffer> getBody() {
            return super.getBody().doOnNext(xva$0 -> this.buffer.write((DataBuffer)xva$0)).doOnError(arg_0 -> this.body.onError(arg_0)).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete);
        }

        private void handleOnComplete() {
            if (!this.body.isTerminated()) {
                byte[] bytes = new byte[this.buffer.readableByteCount()];
                this.buffer.read(bytes);
                this.body.onNext((Object)bytes);
            }
        }
    }

    private static class WiretapClientHttpRequest
    extends ClientHttpRequestDecorator {
        private final DataBuffer buffer;
        private final MonoProcessor<byte[]> body = MonoProcessor.create();

        public WiretapClientHttpRequest(ClientHttpRequest delegate) {
            super(delegate);
            this.buffer = bufferFactory.allocateBuffer();
        }

        public MonoProcessor<byte[]> getContent() {
            return this.body;
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> publisher) {
            return super.writeWith((Publisher<? extends DataBuffer>)Flux.from(publisher).doOnNext(this::handleOnNext).doOnError(this::handleError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete));
        }

        @Override
        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
            return super.writeAndFlushWith((Publisher<? extends Publisher<? extends DataBuffer>>)Flux.from(publisher).map(p -> Flux.from((Publisher)p).doOnNext(this::handleOnNext).doOnError(this::handleError)).doOnError(this::handleError).doOnCancel(this::handleOnComplete).doOnComplete(this::handleOnComplete));
        }

        @Override
        public Mono<Void> setComplete() {
            this.handleOnComplete();
            return super.setComplete();
        }

        private void handleOnNext(DataBuffer buffer) {
            this.buffer.write(buffer);
        }

        private void handleError(Throwable ex) {
            if (!this.body.isTerminated()) {
                this.body.onError(ex);
            }
        }

        private void handleOnComplete() {
            if (!this.body.isTerminated()) {
                byte[] bytes = new byte[this.buffer.readableByteCount()];
                this.buffer.read(bytes);
                this.body.onNext((Object)bytes);
            }
        }
    }

    class Info {
        private final WiretapClientHttpRequest request;
        private final WiretapClientHttpResponse response;

        public Info(WiretapClientHttpRequest request, WiretapClientHttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public ExchangeResult createExchangeResult(@Nullable String uriTemplate) {
            return new ExchangeResult(this.request, this.response, this.request.getContent(), this.response.getContent(), uriTemplate);
        }
    }
}

