/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return request -> {};
    }

    public static RequestMatcher method(HttpMethod method) {
        Assert.notNull((Object)method, "'method' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected HttpMethod", (Object)method, (Object)request.getMethod());
    }

    public static RequestMatcher requestTo(Matcher<String> matcher) {
        Assert.notNull(matcher, "'matcher' must not be null");
        return request -> MatcherAssert.assertThat("Request URI", request.getURI().toString(), matcher);
    }

    public static RequestMatcher requestTo(String expectedUri) {
        Assert.notNull((Object)expectedUri, "'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Request URI", expectedUri, request.getURI().toString());
    }

    public static RequestMatcher requestToUriTemplate(String expectedUri, Object ... uriVars) {
        Assert.notNull((Object)expectedUri, "'uri' must not be null");
        URI uri = UriComponentsBuilder.fromUriString(expectedUri).buildAndExpand(uriVars).encode().toUri();
        return MockRestRequestMatchers.requestTo(uri);
    }

    public static RequestMatcher requestTo(URI uri) {
        Assert.notNull((Object)uri, "'uri' must not be null");
        return request -> AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
    }

    @SafeVarargs
    public static RequestMatcher queryParam(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount("query param", name, params, matchers.length);
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat("Query param", ((List)params.get(name)).get(i), matchers[i]);
            }
        };
    }

    public static RequestMatcher queryParam(String name, String ... expectedValues) {
        return request -> {
            MultiValueMap<String, String> params = MockRestRequestMatchers.getQueryParams(request);
            MockRestRequestMatchers.assertValueCount("query param", name, params, expectedValues.length);
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Query param [" + name + "]", expectedValues[i], ((List)params.get(name)).get(i));
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request) {
        return UriComponentsBuilder.fromUri(request.getURI()).build().getQueryParams();
    }

    private static void assertValueCount(String valueType, String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get(name);
        String message = "Expected " + valueType + " <" + name + ">";
        if (values == null) {
            AssertionErrors.fail(message + " to exist but was null");
        }
        if (count > values.size()) {
            AssertionErrors.fail(message + " to have at least <" + count + "> values but found " + values);
        }
    }

    @SafeVarargs
    public static RequestMatcher header(String name, Matcher<? super String> ... matchers) {
        return request -> {
            MockRestRequestMatchers.assertValueCount("header", name, request.getHeaders(), matchers.length);
            Object headerValues = request.getHeaders().get(name);
            Assert.state(headerValues != null, "No header values");
            for (int i = 0; i < matchers.length; ++i) {
                MatcherAssert.assertThat("Request header [" + name + "]", headerValues.get(i), matchers[i]);
            }
        };
    }

    public static RequestMatcher header(String name, String ... expectedValues) {
        return request -> {
            MockRestRequestMatchers.assertValueCount("header", name, request.getHeaders(), expectedValues.length);
            Object headerValues = request.getHeaders().get(name);
            Assert.state(headerValues != null, "No header values");
            for (int i = 0; i < expectedValues.length; ++i) {
                AssertionErrors.assertEquals("Request header [" + name + "]", expectedValues[i], headerValues.get(i));
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }
}

