/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextResourceUtils {
    private static final String SLASH = "/";

    public static String[] convertToClasspathResourcePaths(Class<?> clazz, String ... paths) {
        String[] convertedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            convertedPaths[i] = path.startsWith(SLASH) ? "classpath:" + path : (!ResourcePatternUtils.isUrl(path) ? "classpath:/" + StringUtils.cleanPath(ClassUtils.classPackageAsResourcePath(clazz) + SLASH + path) : StringUtils.cleanPath(path));
        }
        return convertedPaths;
    }

    public static Resource[] convertToResources(ResourceLoader resourceLoader, String ... paths) {
        return (Resource[])TestContextResourceUtils.stream(resourceLoader, paths).toArray(Resource[]::new);
    }

    public static List<Resource> convertToResourceList(ResourceLoader resourceLoader, String ... paths) {
        return TestContextResourceUtils.stream(resourceLoader, paths).collect(Collectors.toList());
    }

    private static Stream<Resource> stream(ResourceLoader resourceLoader, String ... paths) {
        return Arrays.stream(paths).map(resourceLoader::getResource);
    }
}

