/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ContextLoaderUtils {
    static final String GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX = "ContextHierarchyLevel#";
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);

    ContextLoaderUtils() {
    }

    static List<List<ContextConfigurationAttributes>> resolveContextHierarchyAttributes(Class<?> testClass) {
        Assert.notNull(testClass, "Class must not be null");
        Class<ContextConfiguration> contextConfigType = ContextConfiguration.class;
        Class<ContextHierarchy> contextHierarchyType = ContextHierarchy.class;
        ArrayList<List<ContextConfigurationAttributes>> hierarchyAttributes = new ArrayList<List<ContextConfigurationAttributes>>();
        MetaAnnotationUtils.UntypedAnnotationDescriptor desc = MetaAnnotationUtils.findAnnotationDescriptorForTypes(testClass, contextConfigType, contextHierarchyType);
        Assert.notNull((Object)desc, () -> String.format("Could not find an 'annotation declaring class' for annotation type [%s] or [%s] and test class [%s]", contextConfigType.getName(), contextHierarchyType.getName(), testClass.getName()));
        while (desc != null) {
            Class<?> rootDeclaringClass = desc.getRootDeclaringClass();
            Class<?> declaringClass = desc.getDeclaringClass();
            boolean contextConfigDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextConfigType, declaringClass);
            boolean contextHierarchyDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextHierarchyType, declaringClass);
            if (contextConfigDeclaredLocally && contextHierarchyDeclaredLocally) {
                String msg = String.format("Class [%s] has been configured with both @ContextConfiguration and @ContextHierarchy. Only one of these annotations may be declared on a test class or composed annotation.", declaringClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            ArrayList<ContextConfigurationAttributes> configAttributesList = new ArrayList<ContextConfigurationAttributes>();
            if (contextConfigDeclaredLocally) {
                ContextConfiguration contextConfiguration = AnnotationUtils.synthesizeAnnotation(desc.getAnnotationAttributes(), ContextConfiguration.class, desc.getRootDeclaringClass());
                ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(contextConfiguration, rootDeclaringClass, configAttributesList);
            } else if (contextHierarchyDeclaredLocally) {
                ContextHierarchy contextHierarchy = AnnotationUtils.getAnnotation(declaringClass, contextHierarchyType);
                if (contextHierarchy != null) {
                    for (ContextConfiguration contextConfiguration : contextHierarchy.value()) {
                        ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(contextConfiguration, rootDeclaringClass, configAttributesList);
                    }
                }
            } else {
                String msg = String.format("Test class [%s] has been configured with neither @ContextConfiguration nor @ContextHierarchy as a class-level annotation.", rootDeclaringClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            hierarchyAttributes.add(0, configAttributesList);
            desc = MetaAnnotationUtils.findAnnotationDescriptorForTypes(rootDeclaringClass.getSuperclass(), contextConfigType, contextHierarchyType);
        }
        return hierarchyAttributes;
    }

    static Map<String, List<ContextConfigurationAttributes>> buildContextHierarchyMap(Class<?> testClass) {
        LinkedHashMap<String, List<ContextConfigurationAttributes>> map = new LinkedHashMap<String, List<ContextConfigurationAttributes>>();
        int hierarchyLevel = 1;
        for (List<ContextConfigurationAttributes> configAttributesList : ContextLoaderUtils.resolveContextHierarchyAttributes(testClass)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                String name = configAttributes.getName();
                if (!StringUtils.hasText(name)) {
                    name = GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX + hierarchyLevel;
                }
                if (!map.containsKey(name)) {
                    ++hierarchyLevel;
                    map.put(name, new ArrayList());
                }
                ((List)map.get(name)).add(configAttributes);
            }
        }
        HashSet set = new HashSet(map.values());
        if (set.size() != map.size()) {
            String msg = String.format("The @ContextConfiguration elements configured via @ContextHierarchy in test class [%s] and its superclasses must define unique contexts per hierarchy level.", testClass.getName());
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        return map;
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> testClass) {
        Assert.notNull(testClass, "Class must not be null");
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        MetaAnnotationUtils.AnnotationDescriptor<ContextConfiguration> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        Assert.notNull(descriptor, () -> String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (descriptor != null) {
            ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(descriptor.synthesizeAnnotation(), descriptor.getRootDeclaringClass(), attributesList);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType);
        }
        return attributesList;
    }

    private static void convertContextConfigToConfigAttributesAndAddToList(ContextConfiguration contextConfiguration, Class<?> declaringClass, List<ContextConfigurationAttributes> attributesList) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass.getName()));
        }
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
        if (logger.isTraceEnabled()) {
            logger.trace("Resolved context configuration attributes: " + attributes);
        }
        attributesList.add(attributes);
    }
}

