/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import org.junit.AssumptionViolatedException;
import org.junit.runners.model.Statement;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.util.Assert;

public class ProfileValueChecker
extends Statement {
    private final Statement next;
    private final Class<?> testClass;
    @Nullable
    private final Method testMethod;

    public ProfileValueChecker(Statement next, Class<?> testClass, @Nullable Method testMethod) {
        Assert.notNull((Object)next, "The next statement must not be null");
        Assert.notNull(testClass, "The test class must not be null");
        this.next = next;
        this.testClass = testClass;
        this.testMethod = testMethod;
    }

    @Override
    public void evaluate() throws Throwable {
        if (this.testMethod == null) {
            if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.testClass)) {
                IfProfileValue ann = AnnotatedElementUtils.findMergedAnnotation(this.testClass, IfProfileValue.class);
                throw new AssumptionViolatedException(String.format("Profile configured via [%s] is not enabled in this environment for test class [%s].", ann, this.testClass.getName()));
            }
        } else if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.testMethod, this.testClass)) {
            throw new AssumptionViolatedException(String.format("Profile configured via @IfProfileValue is not enabled in this environment for test method [%s].", this.testMethod));
        }
        this.next.evaluate();
    }
}

