/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.annotation;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.IfProfileValue;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueSourceConfiguration;
import org.springframework.test.annotation.SystemProfileValueSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ProfileValueUtils {
    private static final Log logger = LogFactory.getLog(ProfileValueUtils.class);

    public static ProfileValueSource retrieveProfileValueSource(Class<?> testClass) {
        ProfileValueSource profileValueSource;
        Class profileValueSourceType;
        Assert.notNull(testClass, "testClass must not be null");
        Class<ProfileValueSourceConfiguration> annotationType = ProfileValueSourceConfiguration.class;
        ProfileValueSourceConfiguration config = AnnotatedElementUtils.findMergedAnnotation(testClass, annotationType);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved @ProfileValueSourceConfiguration [" + config + "] for test class [" + testClass.getName() + "]");
        }
        if (config != null) {
            profileValueSourceType = config.value();
        } else {
            profileValueSourceType = (Class)AnnotationUtils.getDefaultValue(annotationType);
            Assert.state(profileValueSourceType != null, "No default ProfileValueSource class");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved ProfileValueSource type [" + profileValueSourceType + "] for class [" + testClass.getName() + "]");
        }
        if (SystemProfileValueSource.class == profileValueSourceType) {
            profileValueSource = SystemProfileValueSource.getInstance();
        } else {
            try {
                profileValueSource = (ProfileValueSource)ReflectionUtils.accessibleConstructor(profileValueSourceType, new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Could not instantiate a ProfileValueSource of type [" + profileValueSourceType + "] for class [" + testClass.getName() + "]: using default.", ex);
                }
                profileValueSource = SystemProfileValueSource.getInstance();
            }
        }
        return profileValueSource;
    }

    public static boolean isTestEnabledInThisEnvironment(Class<?> testClass) {
        IfProfileValue ifProfileValue = AnnotatedElementUtils.findMergedAnnotation(testClass, IfProfileValue.class);
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), ifProfileValue);
    }

    public static boolean isTestEnabledInThisEnvironment(Method testMethod, Class<?> testClass) {
        return ProfileValueUtils.isTestEnabledInThisEnvironment(ProfileValueUtils.retrieveProfileValueSource(testClass), testMethod, testClass);
    }

    public static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, Method testMethod, Class<?> testClass) {
        IfProfileValue ifProfileValue = AnnotatedElementUtils.findMergedAnnotation(testClass, IfProfileValue.class);
        boolean classLevelEnabled = ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        if (classLevelEnabled) {
            ifProfileValue = AnnotatedElementUtils.findMergedAnnotation(testMethod, IfProfileValue.class);
            return ProfileValueUtils.isTestEnabledInThisEnvironment(profileValueSource, ifProfileValue);
        }
        return false;
    }

    private static boolean isTestEnabledInThisEnvironment(ProfileValueSource profileValueSource, @Nullable IfProfileValue ifProfileValue) {
        if (ifProfileValue == null) {
            return true;
        }
        String environmentValue = profileValueSource.get(ifProfileValue.name());
        String[] annotatedValues = ifProfileValue.values();
        if (StringUtils.hasLength(ifProfileValue.value())) {
            Assert.isTrue(annotatedValues.length == 0, () -> "Setting both the 'value' and 'values' attributes of @IfProfileValue is not allowed: choose one or the other.");
            annotatedValues = new String[]{ifProfileValue.value()};
        }
        for (String value : annotatedValues) {
            if (!ObjectUtils.nullSafeEquals(value, environmentValue)) continue;
            return true;
        }
        return false;
    }
}

