/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;

final class DefaultWASUsernameAndGroupsExtractor
implements WASUsernameAndGroupsExtractor {
    private static final Log logger = LogFactory.getLog(DefaultWASUsernameAndGroupsExtractor.class);
    private static final String PORTABLE_REMOTE_OBJECT_CLASSNAME = "javax.rmi.PortableRemoteObject";
    private static final String USER_REGISTRY = "UserRegistry";
    private static Method getRunAsSubject = null;
    private static Method getGroupsForUser = null;
    private static Method getSecurityName = null;
    private static Method narrow = null;
    private static Class<?> wsCredentialClass = null;

    DefaultWASUsernameAndGroupsExtractor() {
    }

    @Override
    public final List<String> getGroupsForCurrentUser() {
        return DefaultWASUsernameAndGroupsExtractor.getWebSphereGroups(DefaultWASUsernameAndGroupsExtractor.getRunAsSubject());
    }

    @Override
    public final String getCurrentUserName() {
        return DefaultWASUsernameAndGroupsExtractor.getSecurityName(DefaultWASUsernameAndGroupsExtractor.getRunAsSubject());
    }

    private static String getSecurityName(Subject subject) {
        Object credential;
        if (logger.isDebugEnabled()) {
            logger.debug("Determining Websphere security name for subject " + subject);
        }
        String userSecurityName = null;
        if (subject != null && (credential = subject.getPublicCredentials(DefaultWASUsernameAndGroupsExtractor.getWSCredentialClass()).iterator().next()) != null) {
            userSecurityName = (String)DefaultWASUsernameAndGroupsExtractor.invokeMethod(DefaultWASUsernameAndGroupsExtractor.getSecurityNameMethod(), credential, new Object[0]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Websphere security name is " + userSecurityName + " for subject " + subject);
        }
        return userSecurityName;
    }

    private static Subject getRunAsSubject() {
        logger.debug("Retrieving WebSphere RunAs subject");
        return (Subject)DefaultWASUsernameAndGroupsExtractor.invokeMethod(DefaultWASUsernameAndGroupsExtractor.getRunAsSubjectMethod(), null, new Object[0]);
    }

    private static List<String> getWebSphereGroups(Subject subject) {
        return DefaultWASUsernameAndGroupsExtractor.getWebSphereGroups(DefaultWASUsernameAndGroupsExtractor.getSecurityName(subject));
    }

    private static List<String> getWebSphereGroups(String securityName) {
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            Object objRef = ic.lookup(USER_REGISTRY);
            Object userReg = DefaultWASUsernameAndGroupsExtractor.invokeMethod(DefaultWASUsernameAndGroupsExtractor.getNarrowMethod(), null, objRef, Class.forName("com.ibm.websphere.security.UserRegistry"));
            if (logger.isDebugEnabled()) {
                logger.debug("Determining WebSphere groups for user " + securityName + " using WebSphere UserRegistry " + userReg);
            }
            Collection groups = (Collection)DefaultWASUsernameAndGroupsExtractor.invokeMethod(DefaultWASUsernameAndGroupsExtractor.getGroupsForUserMethod(), userReg, securityName);
            if (logger.isDebugEnabled()) {
                logger.debug("Groups for user " + securityName + ": " + groups.toString());
            }
            ArrayList<String> arrayList = new ArrayList<String>(groups);
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Exception occured while looking up groups for user", e);
            throw new RuntimeException("Exception occured while looking up groups for user", e);
        }
        finally {
            try {
                if (ic != null) {
                    ic.close();
                }
            }
            catch (NamingException e) {
                logger.debug("Exception occured while closing context", e);
            }
        }
    }

    private static Object invokeMethod(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
            throw new RuntimeException("Error while invoking method " + method.getClass().getName() + "." + method.getName() + "(" + Arrays.asList(args) + ")", e);
        }
    }

    private static Method getMethod(String className, String methodName, String[] parameterTypeNames) {
        try {
            Class<?> c = Class.forName(className);
            int len = parameterTypeNames.length;
            Class[] parameterTypes = new Class[len];
            for (int i = 0; i < len; ++i) {
                parameterTypes[i] = Class.forName(parameterTypeNames[i]);
            }
            return c.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (ClassNotFoundException e) {
            logger.error("Required class" + className + " not found");
            throw new RuntimeException("Required class" + className + " not found", e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Required method " + methodName + " with parameter types (" + Arrays.asList(parameterTypeNames) + ") not found on class " + className);
            throw new RuntimeException("Required class" + className + " not found", e);
        }
    }

    private static Method getRunAsSubjectMethod() {
        if (getRunAsSubject == null) {
            getRunAsSubject = DefaultWASUsernameAndGroupsExtractor.getMethod("com.ibm.websphere.security.auth.WSSubject", "getRunAsSubject", new String[0]);
        }
        return getRunAsSubject;
    }

    private static Method getGroupsForUserMethod() {
        if (getGroupsForUser == null) {
            getGroupsForUser = DefaultWASUsernameAndGroupsExtractor.getMethod("com.ibm.websphere.security.UserRegistry", "getGroupsForUser", new String[]{"java.lang.String"});
        }
        return getGroupsForUser;
    }

    private static Method getSecurityNameMethod() {
        if (getSecurityName == null) {
            getSecurityName = DefaultWASUsernameAndGroupsExtractor.getMethod("com.ibm.websphere.security.cred.WSCredential", "getSecurityName", new String[0]);
        }
        return getSecurityName;
    }

    private static Method getNarrowMethod() {
        if (narrow == null) {
            narrow = DefaultWASUsernameAndGroupsExtractor.getMethod(PORTABLE_REMOTE_OBJECT_CLASSNAME, "narrow", new String[]{Object.class.getName(), Class.class.getName()});
        }
        return narrow;
    }

    private static Class<?> getWSCredentialClass() {
        if (wsCredentialClass == null) {
            wsCredentialClass = DefaultWASUsernameAndGroupsExtractor.getClass("com.ibm.websphere.security.cred.WSCredential");
        }
        return wsCredentialClass;
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error("Required class " + className + " not found");
            throw new RuntimeException("Required class " + className + " not found", e);
        }
    }
}

