/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsa.crypto;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class KeyStoreKeyFactory {
    private Resource resource;
    private char[] password;
    private KeyStore store;
    private Object lock = new Object();
    private String type;

    public KeyStoreKeyFactory(Resource resource, char[] password) {
        this(resource, password, KeyStoreKeyFactory.type(resource));
    }

    private static String type(Resource resource) {
        String ext = StringUtils.getFilenameExtension(resource.getFilename());
        return ext == null ? "jks" : ext;
    }

    public KeyStoreKeyFactory(Resource resource, char[] password, String type) {
        this.resource = resource;
        this.password = password;
        this.type = type;
    }

    public KeyPair getKeyPair(String alias) {
        return this.getKeyPair(alias, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair getKeyPair(String alias, char[] password) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.store == null) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.store = KeyStore.getInstance(this.type);
                        this.store.load(this.resource.getInputStream(), this.password);
                    }
                }
            }
            RSAPrivateCrtKey key = (RSAPrivateCrtKey)this.store.getKey(alias, password);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
            PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
            return new KeyPair(publicKey, key);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load keys from store: " + this.resource, e);
        }
    }
}

