/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorityReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.AbstractServerWebExchangeMatcherRegistry;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerFormLoginAuthenticationConverter;
import org.springframework.security.web.server.ServerHttpBasicAuthenticationConverter;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.HttpBasicServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.LogoutWebFilter;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.authorization.AuthorizationWebFilter;
import org.springframework.security.web.server.authorization.DelegatingReactiveAuthorizationManager;
import org.springframework.security.web.server.authorization.ExceptionTranslationWebFilter;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ReactorContextWebFilter;
import org.springframework.security.web.server.context.SecurityContextServerWebExchangeWebFilter;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.context.WebSessionServerSecurityContextRepository;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.header.CacheControlServerHttpHeadersWriter;
import org.springframework.security.web.server.header.CompositeServerHttpHeadersWriter;
import org.springframework.security.web.server.header.ContentTypeOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.HttpHeaderWriterWebFilter;
import org.springframework.security.web.server.header.ServerHttpHeadersWriter;
import org.springframework.security.web.server.header.StrictTransportSecurityServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XFrameOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.header.XXssProtectionServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCacheWebFilter;
import org.springframework.security.web.server.savedrequest.WebSessionServerRequestCache;
import org.springframework.security.web.server.ui.LoginPageGeneratingWebFilter;
import org.springframework.security.web.server.ui.LogoutPageGeneratingWebFilter;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcherEntry;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ServerHttpSecurity {
    private ServerWebExchangeMatcher securityMatcher = ServerWebExchangeMatchers.anyExchange();
    private AuthorizeExchangeSpec authorizeExchange;
    private HeaderSpec headers = new HeaderSpec();
    private CsrfSpec csrf = new CsrfSpec();
    private ExceptionHandlingSpec exceptionHandling = new ExceptionHandlingSpec();
    private HttpBasicSpec httpBasic;
    private final RequestCacheSpec requestCache = new RequestCacheSpec();
    private FormLoginSpec formLogin;
    private LogoutSpec logout = new LogoutSpec();
    private ReactiveAuthenticationManager authenticationManager;
    private ServerSecurityContextRepository securityContextRepository = new WebSessionServerSecurityContextRepository();
    private ServerAuthenticationEntryPoint authenticationEntryPoint;
    private List<DelegatingServerAuthenticationEntryPoint.DelegateEntry> defaultEntryPoints = new ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry>();
    private ServerAccessDeniedHandler accessDeniedHandler;
    private List<WebFilter> webFilters = new ArrayList<WebFilter>();
    private Throwable built;

    public ServerHttpSecurity securityMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, "matcher cannot be null");
        this.securityMatcher = matcher;
        return this;
    }

    public ServerHttpSecurity addFilterAt(WebFilter webFilter, SecurityWebFiltersOrder order) {
        this.webFilters.add(new OrderedWebFilter(webFilter, order.getOrder()));
        return this;
    }

    private ServerWebExchangeMatcher getSecurityMatcher() {
        return this.securityMatcher;
    }

    public ServerHttpSecurity securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, "securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
        return this;
    }

    public CsrfSpec csrf() {
        if (this.csrf == null) {
            this.csrf = new CsrfSpec();
        }
        return this.csrf;
    }

    public HttpBasicSpec httpBasic() {
        if (this.httpBasic == null) {
            this.httpBasic = new HttpBasicSpec();
        }
        return this.httpBasic;
    }

    public FormLoginSpec formLogin() {
        if (this.formLogin == null) {
            this.formLogin = new FormLoginSpec();
        }
        return this.formLogin;
    }

    public HeaderSpec headers() {
        if (this.headers == null) {
            this.headers = new HeaderSpec();
        }
        return this.headers;
    }

    public ExceptionHandlingSpec exceptionHandling() {
        if (this.exceptionHandling == null) {
            this.exceptionHandling = new ExceptionHandlingSpec();
        }
        return this.exceptionHandling;
    }

    public AuthorizeExchangeSpec authorizeExchange() {
        if (this.authorizeExchange == null) {
            this.authorizeExchange = new AuthorizeExchangeSpec();
        }
        return this.authorizeExchange;
    }

    public LogoutSpec logout() {
        if (this.logout == null) {
            this.logout = new LogoutSpec();
        }
        return this.logout;
    }

    public RequestCacheSpec requestCache() {
        return this.requestCache;
    }

    public ServerHttpSecurity authenticationManager(ReactiveAuthenticationManager manager) {
        this.authenticationManager = manager;
        return this;
    }

    public SecurityWebFilterChain build() {
        WebFilter securityContextRepositoryWebFilter;
        if (this.built != null) {
            throw new IllegalStateException("This has already been built with the following stacktrace. " + this.buildToString());
        }
        this.built = new RuntimeException("First Build Invocation").fillInStackTrace();
        if (this.headers != null) {
            this.headers.configure(this);
        }
        if ((securityContextRepositoryWebFilter = this.securityContextRepositoryWebFilter()) != null) {
            this.webFilters.add(securityContextRepositoryWebFilter);
        }
        if (this.csrf != null) {
            this.csrf.configure(this);
        }
        if (this.httpBasic != null) {
            this.httpBasic.authenticationManager(this.authenticationManager);
            this.httpBasic.configure(this);
        }
        if (this.formLogin != null) {
            this.formLogin.authenticationManager(this.authenticationManager);
            if (this.securityContextRepository != null) {
                this.formLogin.securityContextRepository(this.securityContextRepository);
            }
            if (this.formLogin.authenticationEntryPoint == null) {
                this.webFilters.add(new OrderedWebFilter(new LoginPageGeneratingWebFilter(), SecurityWebFiltersOrder.LOGIN_PAGE_GENERATING.getOrder()));
                this.webFilters.add(new OrderedWebFilter(new LogoutPageGeneratingWebFilter(), SecurityWebFiltersOrder.LOGOUT_PAGE_GENERATING.getOrder()));
            }
            this.formLogin.configure(this);
        }
        if (this.logout != null) {
            this.logout.configure(this);
        }
        this.requestCache.configure(this);
        this.addFilterAt(new SecurityContextServerWebExchangeWebFilter(), SecurityWebFiltersOrder.SECURITY_CONTEXT_SERVER_WEB_EXCHANGE);
        if (this.authorizeExchange != null) {
            ServerAuthenticationEntryPoint authenticationEntryPoint = this.getAuthenticationEntryPoint();
            ExceptionTranslationWebFilter exceptionTranslationWebFilter = new ExceptionTranslationWebFilter();
            if (authenticationEntryPoint != null) {
                exceptionTranslationWebFilter.setAuthenticationEntryPoint(authenticationEntryPoint);
            }
            if (this.accessDeniedHandler != null) {
                exceptionTranslationWebFilter.setAccessDeniedHandler(this.accessDeniedHandler);
            }
            this.addFilterAt(exceptionTranslationWebFilter, SecurityWebFiltersOrder.EXCEPTION_TRANSLATION);
            this.authorizeExchange.configure(this);
        }
        AnnotationAwareOrderComparator.sort(this.webFilters);
        ArrayList<WebFilter> sortedWebFilters = new ArrayList<WebFilter>();
        this.webFilters.forEach(f -> {
            if (f instanceof OrderedWebFilter) {
                f = ((OrderedWebFilter)f).webFilter;
            }
            sortedWebFilters.add((WebFilter)f);
        });
        return new MatcherSecurityWebFilterChain(this.getSecurityMatcher(), sortedWebFilters);
    }

    /*
     * Exception decompiling
     */
    private String buildToString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ServerAuthenticationEntryPoint getAuthenticationEntryPoint() {
        if (this.authenticationEntryPoint != null || this.defaultEntryPoints.isEmpty()) {
            return this.authenticationEntryPoint;
        }
        if (this.defaultEntryPoints.size() == 1) {
            return this.defaultEntryPoints.get(0).getEntryPoint();
        }
        DelegatingServerAuthenticationEntryPoint result = new DelegatingServerAuthenticationEntryPoint(this.defaultEntryPoints);
        result.setDefaultEntryPoint(this.defaultEntryPoints.get(this.defaultEntryPoints.size() - 1).getEntryPoint());
        return result;
    }

    public static ServerHttpSecurity http() {
        return new ServerHttpSecurity();
    }

    private WebFilter securityContextRepositoryWebFilter() {
        ServerSecurityContextRepository repository = this.securityContextRepository;
        if (repository == null) {
            return null;
        }
        ReactorContextWebFilter result = new ReactorContextWebFilter(repository);
        return new OrderedWebFilter(result, SecurityWebFiltersOrder.REACTOR_CONTEXT.getOrder());
    }

    private ServerHttpSecurity() {
    }

    private static class OrderedWebFilter
    implements WebFilter,
    Ordered {
        private final WebFilter webFilter;
        private final int order;

        public OrderedWebFilter(WebFilter webFilter, int order) {
            this.webFilter = webFilter;
            this.order = order;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
            return this.webFilter.filter(exchange2, chain);
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return "OrderedWebFilter{webFilter=" + this.webFilter + ", order=" + this.order + '}';
        }
    }

    public final class LogoutSpec {
        private LogoutWebFilter logoutWebFilter = new LogoutWebFilter();

        public LogoutSpec logoutHandler(ServerLogoutHandler logoutHandler) {
            this.logoutWebFilter.setLogoutHandler(logoutHandler);
            return this;
        }

        public LogoutSpec logoutUrl(String logoutUrl) {
            Assert.notNull((Object)logoutUrl, "logoutUrl must not be null");
            ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers(HttpMethod.POST, logoutUrl);
            return this.requiresLogout(requiresLogout);
        }

        public LogoutSpec requiresLogout(ServerWebExchangeMatcher requiresLogout) {
            this.logoutWebFilter.setRequiresLogoutMatcher(requiresLogout);
            return this;
        }

        public LogoutSpec logoutSuccessHandler(ServerLogoutSuccessHandler handler) {
            this.logoutWebFilter.setLogoutSuccessHandler(handler);
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.logout = null;
            return this.and();
        }

        protected void configure(ServerHttpSecurity http) {
            http.addFilterAt(this.logoutWebFilter, SecurityWebFiltersOrder.LOGOUT);
        }

        private LogoutSpec() {
        }
    }

    public class HeaderSpec {
        private final List<ServerHttpHeadersWriter> writers;
        private CacheControlServerHttpHeadersWriter cacheControl = new CacheControlServerHttpHeadersWriter();
        private ContentTypeOptionsServerHttpHeadersWriter contentTypeOptions = new ContentTypeOptionsServerHttpHeadersWriter();
        private StrictTransportSecurityServerHttpHeadersWriter hsts = new StrictTransportSecurityServerHttpHeadersWriter();
        private XFrameOptionsServerHttpHeadersWriter frameOptions = new XFrameOptionsServerHttpHeadersWriter();
        private XXssProtectionServerHttpHeadersWriter xss = new XXssProtectionServerHttpHeadersWriter();

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.headers = null;
            return ServerHttpSecurity.this;
        }

        public CacheSpec cache() {
            return new CacheSpec();
        }

        public ContentTypeOptionsSpec contentTypeOptions() {
            return new ContentTypeOptionsSpec();
        }

        public FrameOptionsSpec frameOptions() {
            return new FrameOptionsSpec();
        }

        public HstsSpec hsts() {
            return new HstsSpec();
        }

        protected void configure(ServerHttpSecurity http) {
            CompositeServerHttpHeadersWriter writer = new CompositeServerHttpHeadersWriter(this.writers);
            HttpHeaderWriterWebFilter result = new HttpHeaderWriterWebFilter(writer);
            http.addFilterAt(result, SecurityWebFiltersOrder.HTTP_HEADERS_WRITER);
        }

        public XssProtectionSpec xssProtection() {
            return new XssProtectionSpec();
        }

        private HeaderSpec() {
            this.writers = new ArrayList<ServerHttpHeadersWriter>(Arrays.asList(this.cacheControl, this.contentTypeOptions, this.hsts, this.frameOptions, this.xss));
        }

        public class XssProtectionSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.xss);
                return HeaderSpec.this;
            }

            private XssProtectionSpec() {
            }
        }

        public class HstsSpec {
            public void maxAge(Duration maxAge) {
                HeaderSpec.this.hsts.setMaxAge(maxAge);
            }

            public void includeSubdomains(boolean includeSubDomains) {
                HeaderSpec.this.hsts.setIncludeSubDomains(includeSubDomains);
            }

            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.hsts);
                return HeaderSpec.this;
            }

            private HstsSpec() {
            }
        }

        public class FrameOptionsSpec {
            public FrameOptionsSpec mode(XFrameOptionsServerHttpHeadersWriter.Mode mode) {
                HeaderSpec.this.frameOptions.setMode(mode);
                return this;
            }

            public HeaderSpec and() {
                return HeaderSpec.this;
            }

            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.frameOptions);
                return HeaderSpec.this;
            }

            private FrameOptionsSpec() {
            }
        }

        public class ContentTypeOptionsSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.contentTypeOptions);
                return HeaderSpec.this;
            }

            private ContentTypeOptionsSpec() {
            }
        }

        public class CacheSpec {
            public HeaderSpec disable() {
                HeaderSpec.this.writers.remove(HeaderSpec.this.cacheControl);
                return HeaderSpec.this;
            }

            private CacheSpec() {
            }
        }
    }

    public class FormLoginSpec {
        private final RedirectServerAuthenticationSuccessHandler defaultSuccessHandler = new RedirectServerAuthenticationSuccessHandler("/");
        private RedirectServerAuthenticationEntryPoint defaultEntryPoint;
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository = new WebSessionServerSecurityContextRepository();
        private ServerAuthenticationEntryPoint authenticationEntryPoint;
        private ServerWebExchangeMatcher requiresAuthenticationMatcher;
        private ServerAuthenticationFailureHandler authenticationFailureHandler;
        private ServerAuthenticationSuccessHandler authenticationSuccessHandler = this.defaultSuccessHandler;

        public FormLoginSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public FormLoginSpec authenticationSuccessHandler(ServerAuthenticationSuccessHandler authenticationSuccessHandler) {
            Assert.notNull((Object)authenticationSuccessHandler, "authenticationSuccessHandler cannot be null");
            this.authenticationSuccessHandler = authenticationSuccessHandler;
            return this;
        }

        public FormLoginSpec loginPage(String loginPage) {
            this.defaultEntryPoint = new RedirectServerAuthenticationEntryPoint(loginPage);
            this.authenticationEntryPoint = this.defaultEntryPoint;
            this.requiresAuthenticationMatcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.POST, loginPage);
            this.authenticationFailureHandler = new RedirectServerAuthenticationFailureHandler(loginPage + "?error");
            return this;
        }

        public FormLoginSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public FormLoginSpec requiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
            this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
            return this;
        }

        public FormLoginSpec authenticationFailureHandler(ServerAuthenticationFailureHandler authenticationFailureHandler) {
            this.authenticationFailureHandler = authenticationFailureHandler;
            return this;
        }

        public FormLoginSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.formLogin = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.authenticationEntryPoint == null) {
                this.loginPage("/login");
            }
            if (http.requestCache != null) {
                ServerRequestCache requestCache = http.requestCache.requestCache;
                this.defaultSuccessHandler.setRequestCache(requestCache);
                if (this.defaultEntryPoint != null) {
                    this.defaultEntryPoint.setRequestCache(requestCache);
                }
            }
            MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(MediaType.TEXT_HTML);
            htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerHttpSecurity.this.defaultEntryPoints.add(0, new DelegatingServerAuthenticationEntryPoint.DelegateEntry(htmlMatcher, this.authenticationEntryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setRequiresAuthenticationMatcher(this.requiresAuthenticationMatcher);
            authenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
            authenticationFilter.setAuthenticationConverter(new ServerFormLoginAuthenticationConverter());
            authenticationFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
            authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            http.addFilterAt(authenticationFilter, SecurityWebFiltersOrder.FORM_LOGIN);
        }

        private FormLoginSpec() {
        }
    }

    public class HttpBasicSpec {
        private ReactiveAuthenticationManager authenticationManager;
        private ServerSecurityContextRepository securityContextRepository = NoOpServerSecurityContextRepository.getInstance();
        private ServerAuthenticationEntryPoint entryPoint = new HttpBasicServerAuthenticationEntryPoint();

        public HttpBasicSpec authenticationManager(ReactiveAuthenticationManager authenticationManager) {
            this.authenticationManager = authenticationManager;
            return this;
        }

        public HttpBasicSpec securityContextRepository(ServerSecurityContextRepository securityContextRepository) {
            this.securityContextRepository = securityContextRepository;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.httpBasic = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            MediaTypeServerWebExchangeMatcher restMatcher = new MediaTypeServerWebExchangeMatcher(MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_FORM_URLENCODED, MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_XML, MediaType.MULTIPART_FORM_DATA, MediaType.TEXT_XML);
            restMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
            ServerHttpSecurity.this.defaultEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry(restMatcher, this.entryPoint));
            AuthenticationWebFilter authenticationFilter = new AuthenticationWebFilter(this.authenticationManager);
            authenticationFilter.setAuthenticationFailureHandler(new ServerAuthenticationEntryPointFailureHandler(this.entryPoint));
            authenticationFilter.setAuthenticationConverter(new ServerHttpBasicAuthenticationConverter());
            if (this.securityContextRepository != null) {
                authenticationFilter.setSecurityContextRepository(this.securityContextRepository);
            }
            http.addFilterAt(authenticationFilter, SecurityWebFiltersOrder.HTTP_BASIC);
        }

        private HttpBasicSpec() {
        }
    }

    public class RequestCacheSpec {
        private ServerRequestCache requestCache = new WebSessionServerRequestCache();

        public RequestCacheSpec requestCache(ServerRequestCache requestCache) {
            Assert.notNull((Object)requestCache, "requestCache cannot be null");
            this.requestCache = requestCache;
            return this;
        }

        protected void configure(ServerHttpSecurity http) {
            ServerRequestCacheWebFilter filter = new ServerRequestCacheWebFilter();
            filter.setRequestCache(this.requestCache);
            http.addFilterAt(filter, SecurityWebFiltersOrder.SERVER_REQUEST_CACHE);
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            this.requestCache = NoOpServerRequestCache.getInstance();
            return this.and();
        }

        private RequestCacheSpec() {
        }
    }

    public class ExceptionHandlingSpec {
        public ExceptionHandlingSpec authenticationEntryPoint(ServerAuthenticationEntryPoint authenticationEntryPoint) {
            ServerHttpSecurity.this.authenticationEntryPoint = authenticationEntryPoint;
            return this;
        }

        public ExceptionHandlingSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            ServerHttpSecurity.this.accessDeniedHandler = accessDeniedHandler;
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        private ExceptionHandlingSpec() {
        }
    }

    public class CsrfSpec {
        private CsrfWebFilter filter = new CsrfWebFilter();

        public CsrfSpec accessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
            this.filter.setAccessDeniedHandler(accessDeniedHandler);
            return this;
        }

        public CsrfSpec csrfTokenRepository(ServerCsrfTokenRepository csrfTokenRepository) {
            this.filter.setCsrfTokenRepository(csrfTokenRepository);
            return this;
        }

        public CsrfSpec requireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
            this.filter.setRequireCsrfProtectionMatcher(requireCsrfProtectionMatcher);
            return this;
        }

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        public ServerHttpSecurity disable() {
            ServerHttpSecurity.this.csrf = null;
            return ServerHttpSecurity.this;
        }

        protected void configure(ServerHttpSecurity http) {
            http.addFilterAt(this.filter, SecurityWebFiltersOrder.CSRF);
        }

        private CsrfSpec() {
        }
    }

    public class AuthorizeExchangeSpec
    extends AbstractServerWebExchangeMatcherRegistry<Access> {
        private DelegatingReactiveAuthorizationManager.Builder managerBldr = DelegatingReactiveAuthorizationManager.builder();
        private ServerWebExchangeMatcher matcher;
        private boolean anyExchangeRegistered;

        public ServerHttpSecurity and() {
            return ServerHttpSecurity.this;
        }

        @Override
        public Access anyExchange() {
            Access result = (Access)super.anyExchange();
            this.anyExchangeRegistered = true;
            return result;
        }

        @Override
        protected Access registerMatcher(ServerWebExchangeMatcher matcher) {
            if (this.anyExchangeRegistered) {
                throw new IllegalStateException("Cannot register " + matcher + " which would be unreachable because anyExchange() has already been registered.");
            }
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + matcher + " does not have an access rule defined");
            }
            this.matcher = matcher;
            return new Access();
        }

        protected void configure(ServerHttpSecurity http) {
            if (this.matcher != null) {
                throw new IllegalStateException("The matcher " + this.matcher + " does not have an access rule defined");
            }
            AuthorizationWebFilter result = new AuthorizationWebFilter(this.managerBldr.build());
            http.addFilterAt(result, SecurityWebFiltersOrder.AUTHORIZATION);
        }

        public final class Access {
            public AuthorizeExchangeSpec permitAll() {
                return this.access((a, e) -> Mono.just((Object)new AuthorizationDecision(true)));
            }

            public AuthorizeExchangeSpec denyAll() {
                return this.access((a, e) -> Mono.just((Object)new AuthorizationDecision(false)));
            }

            public AuthorizeExchangeSpec hasRole(String role) {
                return this.access(AuthorityReactiveAuthorizationManager.hasRole(role));
            }

            public AuthorizeExchangeSpec hasAuthority(String authority) {
                return this.access(AuthorityReactiveAuthorizationManager.hasAuthority(authority));
            }

            public AuthorizeExchangeSpec authenticated() {
                return this.access(AuthenticatedReactiveAuthorizationManager.authenticated());
            }

            public AuthorizeExchangeSpec access(ReactiveAuthorizationManager<AuthorizationContext> manager) {
                AuthorizeExchangeSpec.this.managerBldr.add(new ServerWebExchangeMatcherEntry<ReactiveAuthorizationManager<AuthorizationContext>>(AuthorizeExchangeSpec.this.matcher, manager));
                AuthorizeExchangeSpec.this.matcher = null;
                return AuthorizeExchangeSpec.this;
            }
        }
    }
}

