/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.http.ChannelAttributeFactory;
import org.springframework.security.config.http.CorsBeanDefinitionParser;
import org.springframework.security.config.http.CsrfBeanDefinitionParser;
import org.springframework.security.config.http.FilterInvocationSecurityMetadataSourceParser;
import org.springframework.security.config.http.GrantedAuthorityDefaultsParserUtils;
import org.springframework.security.config.http.HeadersBeanDefinitionParser;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class HttpConfigurationBuilder {
    private static final String ATT_CREATE_SESSION = "create-session";
    private static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    private static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    private static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    private static final String OPT_CHANGE_SESSION_ID = "changeSessionId";
    private static final String ATT_INVALID_SESSION_URL = "invalid-session-url";
    private static final String ATT_SESSION_AUTH_STRATEGY_REF = "session-authentication-strategy-ref";
    private static final String ATT_SESSION_AUTH_ERROR_URL = "session-authentication-error-url";
    private static final String ATT_SECURITY_CONTEXT_REPOSITORY = "security-context-repository-ref";
    private static final String ATT_INVALID_SESSION_STRATEGY_REF = "invalid-session-strategy-ref";
    private static final String ATT_DISABLE_URL_REWRITING = "disable-url-rewriting";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    private static final String ATT_REF = "ref";
    private final Element httpElt;
    private final ParserContext pc;
    private final SessionCreationPolicy sessionPolicy;
    private final List<Element> interceptUrls;
    private final MatcherType matcherType;
    private BeanDefinition cpf;
    private BeanDefinition securityContextPersistenceFilter;
    private BeanReference contextRepoRef;
    private BeanReference sessionRegistryRef;
    private BeanDefinition concurrentSessionFilter;
    private BeanDefinition webAsyncManagerFilter;
    private BeanDefinition requestCacheAwareFilter;
    private BeanReference sessionStrategyRef;
    private RootBeanDefinition sfpf;
    private BeanDefinition servApiFilter;
    private BeanDefinition jaasApiFilter;
    private final BeanReference portMapper;
    private final BeanReference portResolver;
    private BeanReference fsi;
    private BeanReference requestCache;
    private BeanDefinition addHeadersFilter;
    private BeanMetadataElement corsFilter;
    private BeanDefinition csrfFilter;
    private BeanMetadataElement csrfLogoutHandler;
    private BeanMetadataElement csrfAuthStrategy;
    private CsrfBeanDefinitionParser csrfParser;
    private BeanDefinition invalidSession;
    private boolean addAllAuth;

    public HttpConfigurationBuilder(Element element, boolean addAllAuth, ParserContext pc, BeanReference portMapper, BeanReference portResolver, BeanReference authenticationManager) {
        this.httpElt = element;
        this.addAllAuth = addAllAuth;
        this.pc = pc;
        this.portMapper = portMapper;
        this.portResolver = portResolver;
        this.matcherType = MatcherType.fromElement(element);
        this.interceptUrls = DomUtils.getChildElementsByTagName(element, "intercept-url");
        for (Element urlElt : this.interceptUrls) {
            if (!StringUtils.hasText(urlElt.getAttribute("filters"))) continue;
            pc.getReaderContext().error("The use of \"filters='none'\" is no longer supported. Please define a separate <http> element for the pattern you want to exclude and use the attribute \"security='none'\".", pc.extractSource(urlElt));
        }
        String createSession = element.getAttribute(ATT_CREATE_SESSION);
        this.sessionPolicy = StringUtils.hasText(createSession) ? this.createPolicy(createSession) : SessionCreationPolicy.IF_REQUIRED;
        this.createCsrfFilter();
        this.createSecurityContextPersistenceFilter();
        this.createSessionManagementFilters();
        this.createWebAsyncManagerFilter();
        this.createRequestCacheFilter();
        this.createServletApiFilter(authenticationManager);
        this.createJaasApiFilter();
        this.createChannelProcessingFilter();
        this.createFilterSecurityInterceptor(authenticationManager);
        this.createAddHeadersFilter();
        this.createCorsFilter();
    }

    private SessionCreationPolicy createPolicy(String createSession) {
        if ("ifRequired".equals(createSession)) {
            return SessionCreationPolicy.IF_REQUIRED;
        }
        if ("always".equals(createSession)) {
            return SessionCreationPolicy.ALWAYS;
        }
        if ("never".equals(createSession)) {
            return SessionCreationPolicy.NEVER;
        }
        if ("stateless".equals(createSession)) {
            return SessionCreationPolicy.STATELESS;
        }
        throw new IllegalStateException("Cannot convert " + createSession + " to " + SessionCreationPolicy.class.getName());
    }

    void setLogoutHandlers(ManagedList logoutHandlers) {
        if (logoutHandlers != null) {
            if (this.concurrentSessionFilter != null) {
                this.concurrentSessionFilter.getPropertyValues().add("logoutHandlers", logoutHandlers);
            }
            if (this.servApiFilter != null) {
                this.servApiFilter.getPropertyValues().add("logoutHandlers", logoutHandlers);
            }
        }
    }

    void setEntryPoint(BeanMetadataElement entryPoint) {
        if (this.servApiFilter != null) {
            this.servApiFilter.getPropertyValues().add("authenticationEntryPoint", entryPoint);
        }
    }

    void setAccessDeniedHandler(BeanMetadataElement accessDeniedHandler) {
        if (this.csrfParser != null) {
            this.csrfParser.initAccessDeniedHandler(this.invalidSession, accessDeniedHandler);
        }
    }

    static String createPath(String path, boolean lowerCase) {
        return lowerCase ? path.toLowerCase() : path;
    }

    private void createSecurityContextPersistenceFilter() {
        BeanDefinitionBuilder scpf = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextPersistenceFilter.class);
        String repoRef = this.httpElt.getAttribute(ATT_SECURITY_CONTEXT_REPOSITORY);
        String disableUrlRewriting = this.httpElt.getAttribute(ATT_DISABLE_URL_REWRITING);
        if (!StringUtils.hasText(disableUrlRewriting)) {
            disableUrlRewriting = "true";
        }
        if (StringUtils.hasText(repoRef)) {
            if (this.sessionPolicy == SessionCreationPolicy.ALWAYS) {
                scpf.addPropertyValue("forceEagerSessionCreation", Boolean.TRUE);
            }
        } else {
            BeanDefinitionBuilder contextRepo;
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                contextRepo = BeanDefinitionBuilder.rootBeanDefinition(NullSecurityContextRepository.class);
            } else {
                contextRepo = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSecurityContextRepository.class);
                switch (this.sessionPolicy) {
                    case ALWAYS: {
                        contextRepo.addPropertyValue("allowSessionCreation", Boolean.TRUE);
                        scpf.addPropertyValue("forceEagerSessionCreation", Boolean.TRUE);
                        break;
                    }
                    case NEVER: {
                        contextRepo.addPropertyValue("allowSessionCreation", Boolean.FALSE);
                        scpf.addPropertyValue("forceEagerSessionCreation", Boolean.FALSE);
                        break;
                    }
                    default: {
                        contextRepo.addPropertyValue("allowSessionCreation", Boolean.TRUE);
                        scpf.addPropertyValue("forceEagerSessionCreation", Boolean.FALSE);
                    }
                }
                if ("true".equals(disableUrlRewriting)) {
                    contextRepo.addPropertyValue("disableUrlRewriting", Boolean.TRUE);
                }
            }
            AbstractBeanDefinition repoBean = contextRepo.getBeanDefinition();
            repoRef = this.pc.getReaderContext().generateBeanName(repoBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition(repoBean, repoRef));
        }
        this.contextRepoRef = new RuntimeBeanReference(repoRef);
        scpf.addConstructorArgValue(this.contextRepoRef);
        this.securityContextPersistenceFilter = scpf.getBeanDefinition();
    }

    private void createSessionManagementFilters() {
        Element sessionMgmtElt = DomUtils.getChildElementByTagName(this.httpElt, "session-management");
        Element sessionCtrlElt = null;
        String sessionFixationAttribute = null;
        String invalidSessionUrl = null;
        String invalidSessionStrategyRef = null;
        String sessionAuthStratRef = null;
        String errorUrl = null;
        boolean sessionControlEnabled = false;
        if (sessionMgmtElt != null) {
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                this.pc.getReaderContext().error("session-management  cannot be used in combination with create-session='" + (Object)((Object)SessionCreationPolicy.STATELESS) + "'", this.pc.extractSource(sessionMgmtElt));
            }
            sessionFixationAttribute = sessionMgmtElt.getAttribute(ATT_SESSION_FIXATION_PROTECTION);
            invalidSessionUrl = sessionMgmtElt.getAttribute(ATT_INVALID_SESSION_URL);
            invalidSessionStrategyRef = sessionMgmtElt.getAttribute(ATT_INVALID_SESSION_STRATEGY_REF);
            sessionAuthStratRef = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_STRATEGY_REF);
            errorUrl = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_ERROR_URL);
            sessionCtrlElt = DomUtils.getChildElementByTagName(sessionMgmtElt, "concurrency-control");
            boolean bl = sessionControlEnabled = sessionCtrlElt != null;
            if (StringUtils.hasText(invalidSessionUrl) && StringUtils.hasText(invalidSessionStrategyRef)) {
                this.pc.getReaderContext().error("invalid-session-url attribute cannot be used in combination with the invalid-session-strategy-ref attribute.", sessionMgmtElt);
            }
            if (sessionControlEnabled) {
                if (StringUtils.hasText(sessionAuthStratRef)) {
                    this.pc.getReaderContext().error("session-authentication-strategy-ref attribute cannot be used in combination with <concurrency-control>", this.pc.extractSource(sessionCtrlElt));
                }
                this.createConcurrencyControlFilterAndSessionRegistry(sessionCtrlElt);
            }
        }
        if (!StringUtils.hasText(sessionFixationAttribute)) {
            Method changeSessionIdMethod = ReflectionUtils.findMethod(HttpServletRequest.class, OPT_CHANGE_SESSION_ID);
            sessionFixationAttribute = changeSessionIdMethod == null ? OPT_SESSION_FIXATION_MIGRATE_SESSION : OPT_CHANGE_SESSION_ID;
        } else if (StringUtils.hasText(sessionAuthStratRef)) {
            this.pc.getReaderContext().error("session-fixation-protection attribute cannot be used in combination with session-authentication-strategy-ref", this.pc.extractSource(sessionMgmtElt));
        }
        if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
            return;
        }
        boolean sessionFixationProtectionRequired = !sessionFixationAttribute.equals(OPT_SESSION_FIXATION_NO_PROTECTION);
        ManagedList<BeanMetadataElement> delegateSessionStrategies = new ManagedList<BeanMetadataElement>();
        BeanDefinitionBuilder sessionFixationStrategy = null;
        if (this.csrfAuthStrategy != null) {
            delegateSessionStrategies.add(this.csrfAuthStrategy);
        }
        if (sessionControlEnabled) {
            String exceptionIfMaximumExceeded;
            assert (this.sessionRegistryRef != null);
            BeanDefinitionBuilder concurrentSessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionControlAuthenticationStrategy.class);
            concurrentSessionStrategy.addConstructorArgValue(this.sessionRegistryRef);
            String maxSessions = sessionCtrlElt.getAttribute("max-sessions");
            if (StringUtils.hasText(maxSessions)) {
                concurrentSessionStrategy.addPropertyValue("maximumSessions", maxSessions);
            }
            if (StringUtils.hasText(exceptionIfMaximumExceeded = sessionCtrlElt.getAttribute("error-if-maximum-exceeded"))) {
                concurrentSessionStrategy.addPropertyValue("exceptionIfMaximumExceeded", exceptionIfMaximumExceeded);
            }
            delegateSessionStrategies.add(concurrentSessionStrategy.getBeanDefinition());
        }
        boolean useChangeSessionId = OPT_CHANGE_SESSION_ID.equals(sessionFixationAttribute);
        if (sessionFixationProtectionRequired || StringUtils.hasText(invalidSessionUrl)) {
            sessionFixationStrategy = useChangeSessionId ? BeanDefinitionBuilder.rootBeanDefinition(ChangeSessionIdAuthenticationStrategy.class) : BeanDefinitionBuilder.rootBeanDefinition(SessionFixationProtectionStrategy.class);
            delegateSessionStrategies.add(sessionFixationStrategy.getBeanDefinition());
        }
        if (StringUtils.hasText(sessionAuthStratRef)) {
            delegateSessionStrategies.add(new RuntimeBeanReference(sessionAuthStratRef));
        }
        if (sessionControlEnabled) {
            BeanDefinitionBuilder registerSessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(RegisterSessionAuthenticationStrategy.class);
            registerSessionStrategy.addConstructorArgValue(this.sessionRegistryRef);
            delegateSessionStrategies.add(registerSessionStrategy.getBeanDefinition());
        }
        if (delegateSessionStrategies.isEmpty()) {
            this.sfpf = null;
            return;
        }
        BeanDefinitionBuilder sessionMgmtFilter = BeanDefinitionBuilder.rootBeanDefinition(SessionManagementFilter.class);
        RootBeanDefinition failureHandler = new RootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
        if (StringUtils.hasText(errorUrl)) {
            failureHandler.getPropertyValues().addPropertyValue("defaultFailureUrl", errorUrl);
        }
        sessionMgmtFilter.addPropertyValue("authenticationFailureHandler", failureHandler);
        sessionMgmtFilter.addConstructorArgValue(this.contextRepoRef);
        if (!StringUtils.hasText(sessionAuthStratRef) && sessionFixationStrategy != null && !useChangeSessionId && sessionFixationProtectionRequired) {
            sessionFixationStrategy.addPropertyValue("migrateSessionAttributes", sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
        }
        if (!delegateSessionStrategies.isEmpty()) {
            BeanDefinitionBuilder sessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(CompositeSessionAuthenticationStrategy.class);
            AbstractBeanDefinition strategyBean = sessionStrategy.getBeanDefinition();
            sessionStrategy.addConstructorArgValue(delegateSessionStrategies);
            sessionAuthStratRef = this.pc.getReaderContext().generateBeanName(strategyBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition(strategyBean, sessionAuthStratRef));
        }
        if (StringUtils.hasText(invalidSessionUrl)) {
            BeanDefinitionBuilder invalidSessionBldr = BeanDefinitionBuilder.rootBeanDefinition(SimpleRedirectInvalidSessionStrategy.class);
            invalidSessionBldr.addConstructorArgValue(invalidSessionUrl);
            this.invalidSession = invalidSessionBldr.getBeanDefinition();
            sessionMgmtFilter.addPropertyValue("invalidSessionStrategy", this.invalidSession);
        } else if (StringUtils.hasText(invalidSessionStrategyRef)) {
            sessionMgmtFilter.addPropertyReference("invalidSessionStrategy", invalidSessionStrategyRef);
        }
        sessionMgmtFilter.addConstructorArgReference(sessionAuthStratRef);
        this.sfpf = (RootBeanDefinition)sessionMgmtFilter.getBeanDefinition();
        this.sessionStrategyRef = new RuntimeBeanReference(sessionAuthStratRef);
    }

    private void createConcurrencyControlFilterAndSessionRegistry(Element element) {
        String registryAlias;
        String ATT_EXPIRY_URL = "expired-url";
        String ATT_EXPIRED_SESSION_STRATEGY_REF = "expired-session-strategy-ref";
        String ATT_SESSION_REGISTRY_ALIAS = "session-registry-alias";
        String ATT_SESSION_REGISTRY_REF = "session-registry-ref";
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), this.pc.extractSource(element));
        this.pc.pushContainingComponent(compositeDef);
        BeanDefinitionRegistry beanRegistry = this.pc.getRegistry();
        String sessionRegistryId = element.getAttribute("session-registry-ref");
        if (!StringUtils.hasText(sessionRegistryId)) {
            RootBeanDefinition sessionRegistry = new RootBeanDefinition(SessionRegistryImpl.class);
            sessionRegistryId = this.pc.getReaderContext().registerWithGeneratedName(sessionRegistry);
            this.pc.registerComponent(new BeanComponentDefinition(sessionRegistry, sessionRegistryId));
        }
        if (StringUtils.hasText(registryAlias = element.getAttribute("session-registry-alias"))) {
            beanRegistry.registerAlias(sessionRegistryId, registryAlias);
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionFilter.class);
        filterBuilder.addConstructorArgReference(sessionRegistryId);
        Object source = this.pc.extractSource(element);
        filterBuilder.getRawBeanDefinition().setSource(source);
        filterBuilder.setRole(2);
        String expiryUrl = element.getAttribute("expired-url");
        String expiredSessionStrategyRef = element.getAttribute("expired-session-strategy-ref");
        if (StringUtils.hasText(expiryUrl) && StringUtils.hasText(expiredSessionStrategyRef)) {
            this.pc.getReaderContext().error("Cannot use 'expired-url' attribute and 'expired-session-strategy-ref' attribute together.", source);
        }
        if (StringUtils.hasText(expiryUrl)) {
            BeanDefinitionBuilder expiredSessionBldr = BeanDefinitionBuilder.rootBeanDefinition(SimpleRedirectSessionInformationExpiredStrategy.class);
            expiredSessionBldr.addConstructorArgValue(expiryUrl);
            filterBuilder.addConstructorArgValue(expiredSessionBldr.getBeanDefinition());
        } else if (StringUtils.hasText(expiredSessionStrategyRef)) {
            filterBuilder.addConstructorArgReference(expiredSessionStrategyRef);
        }
        this.pc.popAndRegisterContainingComponent();
        this.concurrentSessionFilter = filterBuilder.getBeanDefinition();
        this.sessionRegistryRef = new RuntimeBeanReference(sessionRegistryId);
    }

    private void createWebAsyncManagerFilter() {
        boolean asyncSupported = ClassUtils.hasMethod(ServletRequest.class, "startAsync", new Class[0]);
        if (asyncSupported) {
            this.webAsyncManagerFilter = new RootBeanDefinition(WebAsyncManagerIntegrationFilter.class);
        }
    }

    private void createServletApiFilter(BeanReference authenticationManager) {
        String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
        String DEF_SERVLET_API_PROVISION = "true";
        String provideServletApi = this.httpElt.getAttribute("servlet-api-provision");
        if (!StringUtils.hasText(provideServletApi)) {
            provideServletApi = "true";
        }
        if ("true".equals(provideServletApi)) {
            this.servApiFilter = GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(this.pc, SecurityContextHolderAwareRequestFilterBeanFactory.class);
            this.servApiFilter.getPropertyValues().add("authenticationManager", authenticationManager);
        }
    }

    private void createJaasApiFilter() {
        String ATT_JAAS_API_PROVISION = "jaas-api-provision";
        String DEF_JAAS_API_PROVISION = "false";
        String provideJaasApi = this.httpElt.getAttribute("jaas-api-provision");
        if (!StringUtils.hasText(provideJaasApi)) {
            provideJaasApi = "false";
        }
        if ("true".equals(provideJaasApi)) {
            this.jaasApiFilter = new RootBeanDefinition(JaasApiIntegrationFilter.class);
        }
    }

    private void createChannelProcessingFilter() {
        ManagedMap<BeanMetadataElement, BeanDefinition> channelRequestMap = this.parseInterceptUrlsForChannelSecurity();
        if (channelRequestMap.isEmpty()) {
            return;
        }
        RootBeanDefinition channelFilter = new RootBeanDefinition(ChannelProcessingFilter.class);
        BeanDefinitionBuilder metadataSourceBldr = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
        metadataSourceBldr.addConstructorArgValue(channelRequestMap);
        channelFilter.getPropertyValues().addPropertyValue("securityMetadataSource", metadataSourceBldr.getBeanDefinition());
        RootBeanDefinition channelDecisionManager = new RootBeanDefinition(ChannelDecisionManagerImpl.class);
        ManagedList<RootBeanDefinition> channelProcessors = new ManagedList<RootBeanDefinition>(3);
        RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(SecureChannelProcessor.class);
        RootBeanDefinition retryWithHttp = new RootBeanDefinition(RetryWithHttpEntryPoint.class);
        RootBeanDefinition retryWithHttps = new RootBeanDefinition(RetryWithHttpsEntryPoint.class);
        retryWithHttp.getPropertyValues().addPropertyValue("portMapper", this.portMapper);
        retryWithHttp.getPropertyValues().addPropertyValue("portResolver", this.portResolver);
        retryWithHttps.getPropertyValues().addPropertyValue("portMapper", this.portMapper);
        retryWithHttps.getPropertyValues().addPropertyValue("portResolver", this.portResolver);
        secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", retryWithHttps);
        RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(InsecureChannelProcessor.class);
        inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", retryWithHttp);
        channelProcessors.add(secureChannelProcessor);
        channelProcessors.add(inSecureChannelProcessor);
        channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", channelProcessors);
        String id = this.pc.getReaderContext().registerWithGeneratedName(channelDecisionManager);
        channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", new RuntimeBeanReference(id));
        this.cpf = channelFilter;
    }

    private ManagedMap<BeanMetadataElement, BeanDefinition> parseInterceptUrlsForChannelSecurity() {
        ManagedMap<BeanMetadataElement, BeanDefinition> channelRequestMap = new ManagedMap<BeanMetadataElement, BeanDefinition>();
        for (Element urlElt : this.interceptUrls) {
            String requiredChannel;
            String path = urlElt.getAttribute("pattern");
            String method = urlElt.getAttribute("method");
            String matcherRef = urlElt.getAttribute("request-matcher-ref");
            boolean hasMatcherRef = StringUtils.hasText(matcherRef);
            if (!hasMatcherRef && !StringUtils.hasText(path)) {
                this.pc.getReaderContext().error("pattern attribute cannot be empty or null", urlElt);
            }
            if (!StringUtils.hasText(requiredChannel = urlElt.getAttribute("requires-channel"))) continue;
            RuntimeBeanReference matcher = hasMatcherRef ? new RuntimeBeanReference(matcherRef) : this.matcherType.createMatcher(this.pc, path, method);
            RootBeanDefinition channelAttributes = new RootBeanDefinition(ChannelAttributeFactory.class);
            channelAttributes.getConstructorArgumentValues().addGenericArgumentValue(requiredChannel);
            channelAttributes.setFactoryMethodName("createChannelAttributes");
            channelRequestMap.put(matcher, channelAttributes);
        }
        return channelRequestMap;
    }

    private void createRequestCacheFilter() {
        Element requestCacheElt = DomUtils.getChildElementByTagName(this.httpElt, "request-cache");
        if (requestCacheElt != null) {
            this.requestCache = new RuntimeBeanReference(requestCacheElt.getAttribute(ATT_REF));
        } else {
            BeanDefinitionBuilder requestCacheBldr;
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                requestCacheBldr = BeanDefinitionBuilder.rootBeanDefinition(NullRequestCache.class);
            } else {
                requestCacheBldr = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionRequestCache.class);
                requestCacheBldr.addPropertyValue("createSessionAllowed", this.sessionPolicy == SessionCreationPolicy.IF_REQUIRED);
                requestCacheBldr.addPropertyValue("portResolver", this.portResolver);
                if (this.csrfFilter != null) {
                    BeanDefinitionBuilder requestCacheMatcherBldr = BeanDefinitionBuilder.rootBeanDefinition(AntPathRequestMatcher.class);
                    requestCacheMatcherBldr.addConstructorArgValue("/**");
                    requestCacheMatcherBldr.addConstructorArgValue("GET");
                    requestCacheBldr.addPropertyValue("requestMatcher", requestCacheMatcherBldr.getBeanDefinition());
                }
            }
            AbstractBeanDefinition bean2 = requestCacheBldr.getBeanDefinition();
            String id = this.pc.getReaderContext().generateBeanName(bean2);
            this.pc.registerBeanComponent(new BeanComponentDefinition(bean2, id));
            this.requestCache = new RuntimeBeanReference(id);
        }
        this.requestCacheAwareFilter = new RootBeanDefinition(RequestCacheAwareFilter.class);
        this.requestCacheAwareFilter.getConstructorArgumentValues().addGenericArgumentValue(this.requestCache);
    }

    private void createFilterSecurityInterceptor(BeanReference authManager) {
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(this.httpElt);
        RootBeanDefinition securityMds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(this.interceptUrls, this.addAllAuth, this.httpElt, this.pc);
        ManagedList<AbstractBeanDefinition> voters = new ManagedList<AbstractBeanDefinition>(2);
        if (useExpressions) {
            BeanDefinitionBuilder expressionVoter = BeanDefinitionBuilder.rootBeanDefinition(WebExpressionVoter.class);
            RuntimeBeanReference expressionHandler = (RuntimeBeanReference)securityMds.getConstructorArgumentValues().getArgumentValue(1, RuntimeBeanReference.class).getValue();
            expressionVoter.addPropertyValue("expressionHandler", expressionHandler);
            voters.add(expressionVoter.getBeanDefinition());
        } else {
            voters.add(GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(this.pc, RoleVoterBeanFactory.class));
            voters.add(new RootBeanDefinition(AuthenticatedVoter.class));
        }
        RootBeanDefinition accessDecisionMgr = new RootBeanDefinition(AffirmativeBased.class);
        accessDecisionMgr.getConstructorArgumentValues().addGenericArgumentValue(voters);
        accessDecisionMgr.setSource(this.pc.extractSource(this.httpElt));
        String accessManagerId = this.httpElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText(accessManagerId)) {
            accessManagerId = this.pc.getReaderContext().generateBeanName(accessDecisionMgr);
            this.pc.registerBeanComponent(new BeanComponentDefinition(accessDecisionMgr, accessManagerId));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FilterSecurityInterceptor.class);
        builder.addPropertyReference("accessDecisionManager", accessManagerId);
        builder.addPropertyValue("authenticationManager", authManager);
        if ("false".equals(this.httpElt.getAttribute(ATT_ONCE_PER_REQUEST))) {
            builder.addPropertyValue("observeOncePerRequest", Boolean.FALSE);
        }
        builder.addPropertyValue("securityMetadataSource", securityMds);
        AbstractBeanDefinition fsiBean = builder.getBeanDefinition();
        String fsiId = this.pc.getReaderContext().generateBeanName(fsiBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition(fsiBean, fsiId));
        RootBeanDefinition wipe = new RootBeanDefinition(DefaultWebInvocationPrivilegeEvaluator.class);
        wipe.getConstructorArgumentValues().addGenericArgumentValue(new RuntimeBeanReference(fsiId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(wipe, this.pc.getReaderContext().generateBeanName(wipe)));
        this.fsi = new RuntimeBeanReference(fsiId);
    }

    private void createAddHeadersFilter() {
        Element elmt = DomUtils.getChildElementByTagName(this.httpElt, "headers");
        this.addHeadersFilter = new HeadersBeanDefinitionParser().parse(elmt, this.pc);
    }

    private void createCorsFilter() {
        Element elmt = DomUtils.getChildElementByTagName(this.httpElt, "cors");
        this.corsFilter = new CorsBeanDefinitionParser().parse(elmt, this.pc);
    }

    private void createCsrfFilter() {
        Element elmt = DomUtils.getChildElementByTagName(this.httpElt, "csrf");
        this.csrfParser = new CsrfBeanDefinitionParser();
        this.csrfFilter = this.csrfParser.parse(elmt, this.pc);
        if (this.csrfFilter == null) {
            this.csrfParser = null;
            return;
        }
        this.csrfAuthStrategy = this.csrfParser.getCsrfAuthenticationStrategy();
        this.csrfLogoutHandler = this.csrfParser.getCsrfLogoutHandler();
    }

    BeanMetadataElement getCsrfLogoutHandler() {
        return this.csrfLogoutHandler;
    }

    BeanReference getSessionStrategy() {
        return this.sessionStrategyRef;
    }

    SessionCreationPolicy getSessionCreationPolicy() {
        return this.sessionPolicy;
    }

    BeanReference getRequestCache() {
        return this.requestCache;
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.cpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.cpf, SecurityFilters.CHANNEL_FILTER));
        }
        if (this.concurrentSessionFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.concurrentSessionFilter, SecurityFilters.CONCURRENT_SESSION_FILTER));
        }
        if (this.webAsyncManagerFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.webAsyncManagerFilter, SecurityFilters.WEB_ASYNC_MANAGER_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.securityContextPersistenceFilter, SecurityFilters.SECURITY_CONTEXT_FILTER));
        if (this.servApiFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.servApiFilter, SecurityFilters.SERVLET_API_SUPPORT_FILTER));
        }
        if (this.jaasApiFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.jaasApiFilter, SecurityFilters.JAAS_API_SUPPORT_FILTER));
        }
        if (this.sfpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.sfpf, SecurityFilters.SESSION_MANAGEMENT_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.fsi, SecurityFilters.FILTER_SECURITY_INTERCEPTOR));
        if (this.sessionPolicy != SessionCreationPolicy.STATELESS) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.requestCacheAwareFilter, SecurityFilters.REQUEST_CACHE_FILTER));
        }
        if (this.corsFilter != null) {
            filters.add(new OrderDecorator(this.corsFilter, SecurityFilters.CORS_FILTER));
        }
        if (this.addHeadersFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.addHeadersFilter, SecurityFilters.HEADERS_FILTER));
        }
        if (this.csrfFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.csrfFilter, SecurityFilters.CSRF_FILTER));
        }
        return filters;
    }

    static class SecurityContextHolderAwareRequestFilterBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private SecurityContextHolderAwareRequestFilter filter = new SecurityContextHolderAwareRequestFilter();

        SecurityContextHolderAwareRequestFilterBeanFactory() {
        }

        @Override
        public SecurityContextHolderAwareRequestFilter getBean() {
            this.filter.setRolePrefix(this.rolePrefix);
            return this.filter;
        }
    }

    static class RoleVoterBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private RoleVoter voter = new RoleVoter();

        RoleVoterBeanFactory() {
        }

        @Override
        public RoleVoter getBean() {
            this.voter.setRolePrefix(this.rolePrefix);
            return this.voter;
        }
    }
}

