/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.http.GrantedAuthorityDefaultsParserUtils;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FilterInvocationSecurityMetadataSourceParser
implements BeanDefinitionParser {
    private static final String ATT_USE_EXPRESSIONS = "use-expressions";
    private static final String ATT_HTTP_METHOD = "method";
    private static final String ATT_PATTERN = "pattern";
    private static final String ATT_ACCESS = "access";
    private static final String ATT_SERVLET_PATH = "servlet-path";
    private static final Log logger = LogFactory.getLog(FilterInvocationSecurityMetadataSourceParser.class);

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        List<Element> interceptUrls = DomUtils.getChildElementsByTagName(element, "intercept-url");
        for (Element elt : interceptUrls) {
            if (StringUtils.hasLength(elt.getAttribute("requires-channel"))) {
                parserContext.getReaderContext().error("The attribute 'requires-channel' isn't allowed here.", elt);
            }
            if (StringUtils.hasLength(elt.getAttribute("filters"))) {
                parserContext.getReaderContext().error("The attribute 'filters' isn't allowed here.", elt);
            }
            if (!StringUtils.hasLength(elt.getAttribute(ATT_SERVLET_PATH))) continue;
            parserContext.getReaderContext().error("The attribute 'servlet-path' isn't allowed here.", elt);
        }
        RootBeanDefinition mds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(interceptUrls, false, element, parserContext);
        String id = element.getAttribute("id");
        if (StringUtils.hasText(id)) {
            parserContext.registerComponent(new BeanComponentDefinition(mds, id));
            parserContext.getRegistry().registerBeanDefinition(id, mds);
        }
        return mds;
    }

    static RootBeanDefinition createSecurityMetadataSource(List<Element> interceptUrls, boolean addAllAuth, Element httpElt, ParserContext pc) {
        BeanDefinitionBuilder fidsBuilder;
        MatcherType matcherType = MatcherType.fromElement(httpElt);
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(httpElt);
        ManagedMap<BeanMetadataElement, BeanDefinition> requestToAttributesMap = FilterInvocationSecurityMetadataSourceParser.parseInterceptUrlsForFilterInvocationRequestMap(matcherType, interceptUrls, useExpressions, addAllAuth, pc);
        if (useExpressions) {
            String expressionHandlerRef;
            Element expressionHandlerElt = DomUtils.getChildElementByTagName(httpElt, "expression-handler");
            String string = expressionHandlerRef = expressionHandlerElt == null ? null : expressionHandlerElt.getAttribute("ref");
            if (StringUtils.hasText(expressionHandlerRef)) {
                logger.info("Using bean '" + expressionHandlerRef + "' as web SecurityExpressionHandler implementation");
            } else {
                expressionHandlerRef = FilterInvocationSecurityMetadataSourceParser.registerDefaultExpressionHandler(pc);
            }
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExpressionBasedFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
            fidsBuilder.addConstructorArgReference(expressionHandlerRef);
        } else {
            fidsBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
            fidsBuilder.addConstructorArgValue(requestToAttributesMap);
        }
        fidsBuilder.getRawBeanDefinition().setSource(pc.extractSource(httpElt));
        return (RootBeanDefinition)fidsBuilder.getBeanDefinition();
    }

    static String registerDefaultExpressionHandler(ParserContext pc) {
        RootBeanDefinition expressionHandler = GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(pc, DefaultWebSecurityExpressionHandlerBeanFactory.class);
        String expressionHandlerRef = pc.getReaderContext().generateBeanName(expressionHandler);
        pc.registerBeanComponent(new BeanComponentDefinition(expressionHandler, expressionHandlerRef));
        return expressionHandlerRef;
    }

    static boolean isUseExpressions(Element elt) {
        String useExpressions = elt.getAttribute(ATT_USE_EXPRESSIONS);
        return !StringUtils.hasText(useExpressions) || "true".equals(useExpressions);
    }

    private static ManagedMap<BeanMetadataElement, BeanDefinition> parseInterceptUrlsForFilterInvocationRequestMap(MatcherType matcherType, List<Element> urlElts, boolean useExpressions, boolean addAuthenticatedAll, ParserContext parserContext) {
        ManagedMap<BeanMetadataElement, BeanDefinition> filterInvocationDefinitionMap = new ManagedMap<BeanMetadataElement, BeanDefinition>();
        for (Element urlElt : urlElts) {
            String servletPath;
            String method;
            String access = urlElt.getAttribute(ATT_ACCESS);
            if (!StringUtils.hasText(access)) continue;
            String path = urlElt.getAttribute(ATT_PATTERN);
            String matcherRef = urlElt.getAttribute("request-matcher-ref");
            boolean hasMatcherRef = StringUtils.hasText(matcherRef);
            if (!hasMatcherRef && !StringUtils.hasText(path)) {
                parserContext.getReaderContext().error("path attribute cannot be empty or null", urlElt);
            }
            if (!StringUtils.hasText(method = urlElt.getAttribute(ATT_HTTP_METHOD))) {
                method = null;
            }
            if (!StringUtils.hasText(servletPath = urlElt.getAttribute(ATT_SERVLET_PATH))) {
                servletPath = null;
            } else if (!MatcherType.mvc.equals((Object)matcherType)) {
                parserContext.getReaderContext().error("servlet-path is not applicable for request-matcher: '" + matcherType.name() + "'", urlElt);
            }
            RuntimeBeanReference matcher = hasMatcherRef ? new RuntimeBeanReference(matcherRef) : matcherType.createMatcher(parserContext, path, method, servletPath);
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            if (useExpressions) {
                logger.info("Creating access control expression attribute '" + access + "' for " + path);
                attributeBuilder.addConstructorArgValue(new String[]{access});
                attributeBuilder.setFactoryMethod("createList");
            } else {
                attributeBuilder.addConstructorArgValue(access);
                attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
            }
            if (filterInvocationDefinitionMap.containsKey(matcher)) {
                logger.warn("Duplicate URL defined: " + path + ". The original attribute values will be overwritten");
            }
            filterInvocationDefinitionMap.put(matcher, attributeBuilder.getBeanDefinition());
        }
        if (addAuthenticatedAll && filterInvocationDefinitionMap.isEmpty()) {
            BeanDefinition matcher = matcherType.createMatcher(parserContext, "/**", null);
            BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
            attributeBuilder.addConstructorArgValue(new String[]{"authenticated"});
            attributeBuilder.setFactoryMethod("createList");
            filterInvocationDefinitionMap.put(matcher, attributeBuilder.getBeanDefinition());
        }
        return filterInvocationDefinitionMap;
    }

    static class DefaultWebSecurityExpressionHandlerBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private DefaultWebSecurityExpressionHandler handler = new DefaultWebSecurityExpressionHandler();

        DefaultWebSecurityExpressionHandlerBeanFactory() {
        }

        @Override
        public DefaultWebSecurityExpressionHandler getBean() {
            this.handler.setDefaultRolePrefix(this.rolePrefix);
            return this.handler;
        }
    }
}

