/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FilterChainBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_REQUEST_MATCHER_REF = "request-matcher-ref";

    @Override
    public BeanDefinition parse(Element elt, ParserContext pc) {
        MatcherType matcherType = MatcherType.fromElement(elt);
        String path = elt.getAttribute("pattern");
        String requestMatcher = elt.getAttribute(ATT_REQUEST_MATCHER_REF);
        String filters = elt.getAttribute("filters");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(DefaultSecurityFilterChain.class);
        if (StringUtils.hasText(path)) {
            Assert.isTrue(!StringUtils.hasText(requestMatcher), "");
            builder.addConstructorArgValue(matcherType.createMatcher(pc, path, null));
        } else {
            Assert.isTrue(StringUtils.hasText(requestMatcher), "");
            builder.addConstructorArgReference(requestMatcher);
        }
        if (filters.equals("none")) {
            builder.addConstructorArgValue(Collections.EMPTY_LIST);
        } else {
            String[] filterBeanNames = StringUtils.tokenizeToStringArray(filters, ",");
            ManagedList<RuntimeBeanReference> filterChain = new ManagedList<RuntimeBeanReference>(filterBeanNames.length);
            for (String name : filterBeanNames) {
                filterChain.add(new RuntimeBeanReference(name));
            }
            builder.addConstructorArgValue(filterChain);
        }
        return builder.getBeanDefinition();
    }
}

