/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PagedResourcesAssembler<T>
implements ResourceAssembler<Page<T>, PagedResources<Resource<T>>> {
    private final HateoasPageableHandlerMethodArgumentResolver pageableResolver;
    private final Optional<UriComponents> baseUri;
    private final EmbeddedWrappers wrappers = new EmbeddedWrappers(false);
    private boolean forceFirstAndLastRels = false;

    public PagedResourcesAssembler(@Nullable HateoasPageableHandlerMethodArgumentResolver resolver, @Nullable UriComponents baseUri) {
        this.pageableResolver = resolver == null ? new HateoasPageableHandlerMethodArgumentResolver() : resolver;
        this.baseUri = Optional.ofNullable(baseUri);
    }

    public void setForceFirstAndLastRels(boolean forceFirstAndLastRels) {
        this.forceFirstAndLastRels = forceFirstAndLastRels;
    }

    public PagedResources<Resource<T>> toResource(Page<T> entity) {
        return this.toResource(entity, it -> new Resource(it, new Link[0]));
    }

    public PagedResources<Resource<T>> toResource(Page<T> page, Link selfLink) {
        return this.toResource(page, it -> new Resource(it, new Link[0]), selfLink);
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler) {
        return this.createResource(page, assembler, Optional.empty());
    }

    public <R extends ResourceSupport> PagedResources<R> toResource(Page<T> page, ResourceAssembler<T, R> assembler, Link link) {
        Assert.notNull((Object)link, "Link must not be null!");
        return this.createResource(page, assembler, Optional.of(link));
    }

    public PagedResources<?> toEmptyResource(Page<?> page, Class<?> type) {
        return this.toEmptyResource(page, type, Optional.empty());
    }

    public PagedResources<?> toEmptyResource(Page<?> page, Class<?> type, Link link) {
        return this.toEmptyResource(page, type, Optional.of(link));
    }

    private PagedResources<?> toEmptyResource(Page<?> page, Class<?> type, Optional<Link> link) {
        Assert.notNull(page, "Page must must not be null!");
        Assert.isTrue(!page.hasContent(), "Page must not have any content!");
        Assert.notNull(type, "Type must not be null!");
        Assert.notNull(link, "Link must not be null!");
        PagedResources.PageMetadata metadata = this.asPageMetadata(page);
        EmbeddedWrapper wrapper = this.wrappers.emptyCollectionOf(type);
        List<EmbeddedWrapper> embedded = Collections.singletonList(wrapper);
        return this.addPaginationLinks(new PagedResources(embedded, metadata, new Link[0]), page, link);
    }

    protected <R extends ResourceSupport, S> PagedResources<R> createPagedResource(List<R> resources, PagedResources.PageMetadata metadata, Page<S> page) {
        Assert.notNull(resources, "Content resources must not be null!");
        Assert.notNull((Object)metadata, "PageMetadata must not be null!");
        Assert.notNull(page, "Page must not be null!");
        return new PagedResources(resources, metadata, new Link[0]);
    }

    private <S, R extends ResourceSupport> PagedResources<R> createResource(Page<S> page, ResourceAssembler<S, R> assembler, Optional<Link> link) {
        Assert.notNull(page, "Page must not be null!");
        Assert.notNull(assembler, "ResourceAssembler must not be null!");
        ArrayList<ResourceSupport> resources = new ArrayList<ResourceSupport>(page.getNumberOfElements());
        for (Object element : page) {
            resources.add(assembler.toResource(element));
        }
        PagedResources resource = this.createPagedResource(resources, this.asPageMetadata(page), page);
        return this.addPaginationLinks(resource, page, link);
    }

    private <R> PagedResources<R> addPaginationLinks(PagedResources<R> resources, Page<?> page, Optional<Link> link) {
        boolean isNavigable;
        UriTemplate base = this.getUriTemplate(link);
        boolean bl = isNavigable = page.hasPrevious() || page.hasNext();
        if (isNavigable || this.forceFirstAndLastRels) {
            resources.add(this.createLink(base, PageRequest.of(0, page.getSize(), page.getSort()), "first"));
        }
        if (page.hasPrevious()) {
            resources.add(this.createLink(base, page.previousPageable(), "prev"));
        }
        Link selfLink = link.map(it -> it.withSelfRel()).orElseGet(() -> this.createLink(base, page.getPageable(), "self"));
        resources.add(selfLink);
        if (page.hasNext()) {
            resources.add(this.createLink(base, page.nextPageable(), "next"));
        }
        if (isNavigable || this.forceFirstAndLastRels) {
            int lastIndex = page.getTotalPages() == 0 ? 0 : page.getTotalPages() - 1;
            resources.add(this.createLink(base, PageRequest.of(lastIndex, page.getSize(), page.getSort()), "last"));
        }
        return resources;
    }

    private UriTemplate getUriTemplate(Optional<Link> baseLink) {
        return new UriTemplate(baseLink.map(Link::getHref).orElseGet(this::baseUriOrCurrentRequest));
    }

    private Link createLink(UriTemplate base, Pageable pageable, String rel) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri(base.expand(new Object[0]));
        this.pageableResolver.enhance(builder, this.getMethodParameter(), pageable);
        return new Link(new UriTemplate(builder.build().toString()), rel);
    }

    @Nullable
    protected MethodParameter getMethodParameter() {
        return null;
    }

    private PagedResources.PageMetadata asPageMetadata(Page<?> page) {
        Assert.notNull(page, "Page must not be null!");
        int number = this.pageableResolver.isOneIndexedParameters() ? page.getNumber() + 1 : page.getNumber();
        return new PagedResources.PageMetadata((long)page.getSize(), (long)number, page.getTotalElements(), (long)page.getTotalPages());
    }

    private String baseUriOrCurrentRequest() {
        return this.baseUri.map(Object::toString).orElseGet(PagedResourcesAssembler::currentRequest);
    }

    private static String currentRequest() {
        return ServletUriComponentsBuilder.fromCurrentRequest().build().toString();
    }
}

