/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query.spi;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public class Function {
    private final Method method;
    @Nullable
    private final Object target;

    public Function(Method method) {
        this(method, null);
        Assert.isTrue(Modifier.isStatic(method.getModifiers()), "Method must be static!");
    }

    public Function(Method method, @Nullable Object target) {
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.isTrue(target != null || Modifier.isStatic(method.getModifiers()), "Method must either be static or a non-static one with a target object!");
        this.method = method;
        this.target = target;
    }

    public Object invoke(Object[] arguments) throws Exception {
        return this.method.invoke(this.target, arguments);
    }

    public String getName() {
        return this.method.getName();
    }

    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public boolean supports(List<TypeDescriptor> argumentTypes) {
        if (this.method.getParameterCount() != argumentTypes.size()) {
            return false;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (TypeUtils.isAssignable(parameterTypes[i], argumentTypes.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    public int getParameterCount() {
        return this.method.getParameterCount();
    }

    public boolean supportsExact(List<TypeDescriptor> argumentTypes) {
        if (this.method.getParameterCount() != argumentTypes.size()) {
            return false;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == argumentTypes.get(i).getType()) continue;
            return false;
        }
        return true;
    }

    public boolean isSignatureEqual(Function other) {
        return this.getName().equals(other.getName()) && Arrays.equals(this.method.getParameterTypes(), other.method.getParameterTypes());
    }
}

