/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.data.repository.config.SpringDataAnnotationBeanNameGenerator;
import org.springframework.util.ClassUtils;

public class RepositoryBeanNameGenerator {
    private static final SpringDataAnnotationBeanNameGenerator DELEGATE = new SpringDataAnnotationBeanNameGenerator();
    private final ClassLoader beanClassLoader;

    public String generateBeanName(BeanDefinition definition) {
        AnnotatedBeanDefinition beanDefinition = definition instanceof AnnotatedBeanDefinition ? (AnnotatedBeanDefinition)definition : new AnnotatedGenericBeanDefinition(this.getRepositoryInterfaceFrom(definition));
        return DELEGATE.generateBeanName(beanDefinition);
    }

    private Class<?> getRepositoryInterfaceFrom(BeanDefinition beanDefinition) {
        ConstructorArgumentValues.ValueHolder argumentValue = beanDefinition.getConstructorArgumentValues().getArgumentValue(0, Class.class);
        if (argumentValue == null) {
            throw new IllegalStateException(String.format("Failed to obtain first constructor parameter value of BeanDefinition %s!", beanDefinition));
        }
        Object value = argumentValue.getValue();
        if (value == null) {
            throw new IllegalStateException(String.format("Value of first constructor parameter value of BeanDefinition %s is null!", beanDefinition));
        }
        if (value instanceof Class) {
            return (Class)value;
        }
        try {
            return ClassUtils.forName(value.toString(), this.beanClassLoader);
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
    }

    public RepositoryBeanNameGenerator(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }
}

