/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryFragmentConfiguration;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryFragmentsFactoryBean;
import org.springframework.data.repository.query.ExtensionAwareEvaluationContextProvider;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class RepositoryBeanDefinitionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryBeanDefinitionBuilder.class);
    private final BeanDefinitionRegistry registry;
    private final RepositoryConfigurationExtension extension;
    private final ResourceLoader resourceLoader;
    private final MetadataReaderFactory metadataReaderFactory;
    private final CustomRepositoryImplementationDetector implementationDetector;

    public RepositoryBeanDefinitionBuilder(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, ResourceLoader resourceLoader, Environment environment2) {
        Assert.notNull((Object)extension, "RepositoryConfigurationExtension must not be null!");
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null!");
        Assert.notNull((Object)environment2, "Environment must not be null!");
        this.registry = registry;
        this.extension = extension;
        this.resourceLoader = resourceLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        this.implementationDetector = new CustomRepositoryImplementationDetector(this.metadataReaderFactory, environment2, resourceLoader);
    }

    public BeanDefinitionBuilder build(RepositoryConfiguration<?> configuration) {
        Assert.notNull((Object)this.registry, "BeanDefinitionRegistry must not be null!");
        Assert.notNull((Object)this.resourceLoader, "ResourceLoader must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configuration.getRepositoryFactoryBeanClassName());
        builder.getRawBeanDefinition().setSource(configuration.getSource());
        builder.addConstructorArgValue(configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", configuration.getQueryLookupStrategyKey());
        builder.addPropertyValue("lazyInit", configuration.isLazyInit());
        configuration.getRepositoryBaseClassName().ifPresent(it -> builder.addPropertyValue("repositoryBaseClass", it));
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        configuration.getNamedQueriesLocation().ifPresent(definitionBuilder::setLocations);
        builder.addPropertyValue("namedQueries", definitionBuilder.build(configuration.getSource()));
        this.registerCustomImplementation(configuration).ifPresent(it -> {
            builder.addPropertyReference("customImplementation", (String)it);
            builder.addDependsOn((String)it);
        });
        BeanDefinitionBuilder fragmentsBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragmentsFactoryBean.class);
        List fragmentBeanNames = this.registerRepositoryFragmentsImplementation(configuration).map(RepositoryFragmentConfiguration::getFragmentBeanName).collect(Collectors.toList());
        fragmentsBuilder.addConstructorArgValue(fragmentBeanNames);
        builder.addPropertyValue("repositoryFragments", ParsingUtils.getSourceBeanDefinition(fragmentsBuilder, configuration.getSource()));
        RootBeanDefinition evaluationContextProviderDefinition = new RootBeanDefinition(ExtensionAwareEvaluationContextProvider.class);
        evaluationContextProviderDefinition.setSource(configuration.getSource());
        builder.addPropertyValue("evaluationContextProvider", evaluationContextProviderDefinition);
        return builder;
    }

    private Optional<String> registerCustomImplementation(RepositoryConfiguration<?> configuration) {
        String beanName = configuration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return Optional.of(beanName);
        }
        Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(configuration);
        return beanDefinition.map(it -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering custom repository implementation: " + configuration.getImplementationBeanName() + " " + it.getBeanClassName());
            }
            it.setSource(configuration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)it);
            return beanName;
        });
    }

    private Stream<RepositoryFragmentConfiguration> registerRepositoryFragmentsImplementation(RepositoryConfiguration<?> configuration) {
        ClassMetadata classMetadata = this.getClassMetadata(configuration.getRepositoryInterface());
        return Arrays.stream(classMetadata.getInterfaceNames()).filter(it -> FragmentMetadata.isCandidate(it, this.metadataReaderFactory)).map(it -> FragmentMetadata.of(it, configuration)).map(it -> this.detectRepositoryFragmentConfiguration((FragmentMetadata)it)).flatMap(it -> Optionals.toStream(it)).peek(it -> this.potentiallyRegisterFragmentImplementation(configuration, (RepositoryFragmentConfiguration)it)).peek(it -> this.potentiallyRegisterRepositoryFragment(configuration, (RepositoryFragmentConfiguration)it));
    }

    private Optional<RepositoryFragmentConfiguration> detectRepositoryFragmentConfiguration(FragmentMetadata configuration) {
        String className = configuration.getFragmentImplementationClassName();
        Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(className, null, configuration.getBasePackages(), configuration.getExclusions(), configuration.getBeanNameGenerator());
        return beanDefinition.map(bd -> new RepositoryFragmentConfiguration(configuration.getFragmentInterfaceName(), (AbstractBeanDefinition)bd));
    }

    private void potentiallyRegisterFragmentImplementation(RepositoryConfiguration<?> repositoryConfiguration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Registering repository fragment implementation: %s %s", beanName, fragmentConfiguration.getClassName()));
        }
        fragmentConfiguration.getBeanDefinition().ifPresent(bd -> {
            bd.setSource(repositoryConfiguration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        });
    }

    private void potentiallyRegisterRepositoryFragment(RepositoryConfiguration<?> configuration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getFragmentBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering repository fragment: " + beanName);
        }
        BeanDefinitionBuilder fragmentBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragment.class, "implemented");
        fragmentBuilder.addConstructorArgValue(fragmentConfiguration.getInterfaceName());
        fragmentBuilder.addConstructorArgReference(fragmentConfiguration.getImplementationBeanName());
        this.registry.registerBeanDefinition(beanName, ParsingUtils.getSourceBeanDefinition(fragmentBuilder, configuration.getSource()));
    }

    private ClassMetadata getClassMetadata(String className) {
        try {
            return this.metadataReaderFactory.getMetadataReader(className).getClassMetadata();
        }
        catch (IOException e) {
            throw new BeanDefinitionStoreException(String.format("Cannot parse %s metadata.", className), e);
        }
    }

    static final class FragmentMetadata {
        private final String fragmentInterfaceName;
        private final RepositoryConfiguration<?> configuration;

        public static boolean isCandidate(String interfaceName, MetadataReaderFactory factory) {
            Assert.hasText(interfaceName, "Interface name must not be null or empty!");
            Assert.notNull((Object)factory, "MetadataReaderFactory must not be null!");
            AnnotationMetadata metadata = FragmentMetadata.getAnnotationMetadata(interfaceName, factory);
            return !metadata.hasAnnotation(NoRepositoryBean.class.getName());
        }

        public List<TypeFilter> getExclusions() {
            Stream<TypeFilter> configurationExcludes = this.configuration.getExcludeFilters().stream();
            Stream<AnnotationTypeFilter> noRepositoryBeans = Stream.of(new AnnotationTypeFilter(NoRepositoryBean.class));
            return Stream.concat(configurationExcludes, noRepositoryBeans).collect(StreamUtils.toUnmodifiableList());
        }

        public String getFragmentImplementationClassName() {
            Object configurationSource = this.configuration.getConfigurationSource();
            String postfix = configurationSource.getRepositoryImplementationPostfix().orElse("Impl");
            return ClassUtils.getShortName(this.fragmentInterfaceName).concat(postfix);
        }

        public Iterable<String> getBasePackages() {
            return Collections.singleton(ClassUtils.getPackageName(this.fragmentInterfaceName));
        }

        public Function<BeanDefinition, String> getBeanNameGenerator() {
            return definition -> this.configuration.getConfigurationSource().generateBeanName((BeanDefinition)definition);
        }

        private static AnnotationMetadata getAnnotationMetadata(String className, MetadataReaderFactory metadataReaderFactory) {
            try {
                return metadataReaderFactory.getMetadataReader(className).getAnnotationMetadata();
            }
            catch (IOException e) {
                throw new BeanDefinitionStoreException(String.format("Cannot parse %s metadata.", className), e);
            }
        }

        private FragmentMetadata(String fragmentInterfaceName, RepositoryConfiguration<?> configuration) {
            this.fragmentInterfaceName = fragmentInterfaceName;
            this.configuration = configuration;
        }

        public static FragmentMetadata of(String fragmentInterfaceName, RepositoryConfiguration<?> configuration) {
            return new FragmentMetadata(fragmentInterfaceName, configuration);
        }

        public String getFragmentInterfaceName() {
            return this.fragmentInterfaceName;
        }

        public RepositoryConfiguration<?> getConfiguration() {
            return this.configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FragmentMetadata)) {
                return false;
            }
            FragmentMetadata other = (FragmentMetadata)o;
            String this$fragmentInterfaceName = this.getFragmentInterfaceName();
            String other$fragmentInterfaceName = other.getFragmentInterfaceName();
            if (this$fragmentInterfaceName == null ? other$fragmentInterfaceName != null : !this$fragmentInterfaceName.equals(other$fragmentInterfaceName)) {
                return false;
            }
            RepositoryConfiguration<?> this$configuration = this.getConfiguration();
            RepositoryConfiguration<?> other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fragmentInterfaceName = this.getFragmentInterfaceName();
            result = result * 59 + ($fragmentInterfaceName == null ? 43 : $fragmentInterfaceName.hashCode());
            RepositoryConfiguration<?> $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
            return result;
        }

        public String toString() {
            return "RepositoryBeanDefinitionBuilder.FragmentMetadata(fragmentInterfaceName=" + this.getFragmentInterfaceName() + ", configuration=" + this.getConfiguration() + ")";
        }
    }
}

