/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import lombok.NonNull;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.lang.Nullable;

public class SpELExpressionParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    @NonNull
    private final SpELExpressionEvaluator evaluator;
    @NonNull
    private final ConversionService conversionService;
    @NonNull
    private final ParameterValueProvider<P> delegate;

    @Override
    @Nullable
    public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
        if (!parameter.hasSpelExpression()) {
            return this.delegate == null ? null : (T)this.delegate.getParameterValue(parameter);
        }
        Object object = this.evaluator.evaluate(parameter.getSpelExpression());
        return object == null ? null : (T)this.potentiallyConvertSpelValue(object, parameter);
    }

    @Nullable
    protected <T> T potentiallyConvertSpelValue(Object object, PreferredConstructor.Parameter<T, P> parameter) {
        return this.conversionService.convert(object, parameter.getRawType());
    }

    public SpELExpressionParameterValueProvider(@NonNull SpELExpressionEvaluator evaluator, @NonNull ConversionService conversionService, @NonNull ParameterValueProvider<P> delegate) {
        if (evaluator == null) {
            throw new IllegalArgumentException("evaluator is null");
        }
        if (conversionService == null) {
            throw new IllegalArgumentException("conversionService is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        this.evaluator = evaluator;
        this.conversionService = conversionService;
        this.delegate = delegate;
    }
}

