/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertingPropertyAccessor
implements PersistentPropertyAccessor {
    private final PersistentPropertyAccessor accessor;
    private final ConversionService conversionService;

    public ConvertingPropertyAccessor(PersistentPropertyAccessor accessor, ConversionService conversionService) {
        Assert.notNull((Object)accessor, "PersistentPropertyAccessor must not be null!");
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        this.accessor = accessor;
        this.conversionService = conversionService;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
        this.accessor.setProperty(property, this.convertIfNecessary(value, property.getType()));
    }

    @Override
    @Nullable
    public Object getProperty(PersistentProperty<?> property) {
        return this.accessor.getProperty(property);
    }

    @Nullable
    public <T> T getProperty(PersistentProperty<?> property, Class<T> targetType) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        Assert.notNull(targetType, "Target type must not be null!");
        return this.convertIfNecessary(this.getProperty(property), targetType);
    }

    @Override
    public Object getBean() {
        return this.accessor.getBean();
    }

    @Nullable
    private <T> T convertIfNecessary(@Nullable Object source, Class<T> type) {
        return (T)(source == null ? null : (type.isAssignableFrom(source.getClass()) ? source : this.conversionService.convert(source, type)));
    }
}

