/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class BeanWrapper<T>
implements PersistentPropertyAccessor {
    private final T bean;

    protected BeanWrapper(T bean2) {
        Assert.notNull(bean2, "Bean must not be null!");
        this.bean = bean2;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getRequiredField();
                ReflectionUtils.makeAccessible(field);
                ReflectionUtils.setField(field, this.bean, value);
                return;
            }
            Method setter = property.getRequiredSetter();
            ReflectionUtils.makeAccessible(setter);
            ReflectionUtils.invokeMethod(setter, this.bean, value);
        }
        catch (IllegalStateException e) {
            throw new MappingException("Could not set object property!", e);
        }
    }

    @Override
    @Nullable
    public Object getProperty(PersistentProperty<?> property) {
        return this.getProperty(property, property.getType());
    }

    @Nullable
    public <S> Object getProperty(PersistentProperty<?> property, Class<? extends S> type) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        try {
            if (!property.usePropertyAccess()) {
                Field field = property.getRequiredField();
                ReflectionUtils.makeAccessible(field);
                return ReflectionUtils.getField(field, this.bean);
            }
            Method getter = property.getRequiredGetter();
            ReflectionUtils.makeAccessible(getter);
            return ReflectionUtils.invokeMethod(getter, this.bean);
        }
        catch (IllegalStateException e) {
            throw new MappingException(String.format("Could not read property %s of %s!", property.toString(), this.bean.toString()), e);
        }
    }

    public T getBean() {
        return this.bean;
    }
}

