/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class PersistentEntities
implements Streamable<PersistentEntity<?, ? extends PersistentProperty<?>>> {
    private final Streamable<? extends MappingContext<?, ?>> contexts;

    public PersistentEntities(Iterable<? extends MappingContext<?, ?>> contexts) {
        Assert.notNull(contexts, "MappingContexts must not be null!");
        this.contexts = Streamable.of(contexts);
    }

    public Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> getPersistentEntity(Class<?> type) {
        return this.contexts.stream().filter(it -> it.hasPersistentEntityFor(type)).findFirst().map((? super T it) -> it.getRequiredPersistentEntity(type));
    }

    public PersistentEntity<?, ? extends PersistentProperty<?>> getRequiredPersistentEntity(Class<?> type) {
        Assert.notNull(type, "Domain type must not be null!");
        return this.getPersistentEntity(type).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find PersistentEntity for type %s!", type)));
    }

    public Streamable<TypeInformation<?>> getManagedTypes() {
        return Streamable.of(this.contexts.stream().flatMap(it -> it.getManagedTypes().stream()).collect(Collectors.toSet()));
    }

    @Override
    public Iterator<PersistentEntity<?, ? extends PersistentProperty<?>>> iterator() {
        return this.contexts.stream().flatMap(it -> it.getPersistentEntities().stream()).collect(Collectors.toList()).iterator();
    }
}

