/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.util.Assert;

public class JpaMetamodel {
    private final Metamodel metamodel;
    private Optional<Collection<Class<?>>> managedTypes = Optional.empty();

    public JpaMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, "Metamodel must not be null!");
        this.metamodel = metamodel;
    }

    public boolean isJpaManaged(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        return this.getManagedTypes().contains(type);
    }

    public boolean isSingleIdAttribute(Class<?> entity, String name, Class<?> attributeType) {
        return this.metamodel.getEntities().stream().filter(it -> entity.equals(it.getJavaType())).findFirst().flatMap(it -> JpaMetamodel.getSingularIdAttribute(it)).filter(it -> it.getJavaType().equals(attributeType)).map(it -> it.getName().equals(name)).orElse(false);
    }

    private Collection<Class<?>> getManagedTypes() {
        if (!this.managedTypes.isPresent()) {
            Set<ManagedType<?>> managedTypes = this.metamodel.getManagedTypes();
            HashSet types = new HashSet(managedTypes.size());
            for (ManagedType<?> managedType : this.metamodel.getManagedTypes()) {
                Class type = managedType.getJavaType();
                if (type == null) continue;
                types.add(type);
            }
            this.managedTypes = Optional.of(Collections.unmodifiableSet(types));
        }
        return this.managedTypes.get();
    }

    private static Optional<? extends SingularAttribute<?, ?>> getSingularIdAttribute(EntityType<?> entityType) {
        if (!entityType.hasSingleIdAttribute()) {
            return Optional.empty();
        }
        return entityType.getSingularAttributes().stream().filter(SingularAttribute::isId).findFirst();
    }
}

