/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;

class DefaultQueryHints
implements QueryHints {
    private final JpaEntityInformation<?, ?> information;
    private final CrudMethodMetadata metadata;
    private final Optional<EntityManager> entityManager;

    private DefaultQueryHints(JpaEntityInformation<?, ?> information, CrudMethodMetadata metadata, Optional<EntityManager> entityManager) {
        this.information = information;
        this.metadata = metadata;
        this.entityManager = entityManager;
    }

    public static QueryHints of(JpaEntityInformation<?, ?> information, CrudMethodMetadata metadata) {
        Assert.notNull(information, "JpaEntityInformation must not be null!");
        Assert.notNull((Object)metadata, "CrudMethodMetadata must not be null!");
        return new DefaultQueryHints(information, metadata, Optional.empty());
    }

    @Override
    public QueryHints withFetchGraphs(EntityManager em) {
        return new DefaultQueryHints(this.information, this.metadata, Optional.of(em));
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.asMap().entrySet().iterator();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        hints.putAll(this.metadata.getQueryHints());
        hints.putAll(this.getFetchGraphs());
        return hints;
    }

    private Map<String, Object> getFetchGraphs() {
        return Optionals.mapIfAllPresent(this.entityManager, this.metadata.getEntityGraph(), (em, graph) -> Jpa21Utils.tryGetFetchGraphHints(em, this.getEntityGraph((EntityGraph)graph), this.information.getJavaType())).orElse(Collections.emptyMap());
    }

    private JpaEntityGraph getEntityGraph(EntityGraph entityGraph) {
        String fallbackName = this.information.getEntityName() + "." + this.metadata.getMethod().getName();
        return new JpaEntityGraph(entityGraph, fallbackName);
    }
}

