/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;

final class NamedQuery
extends AbstractJpaQuery {
    private static final String CANNOT_EXTRACT_QUERY = "Your persistence provider does not support extracting the JPQL query from a named query thus you can't use Pageable inside your query method. Make sure you have a JpaDialect configured at your EntityManagerFactoryBean as this affects discovering the concrete persistence provider.";
    private static final Logger LOG = LoggerFactory.getLogger(NamedQuery.class);
    private final String queryName;
    private final String countQueryName;
    @Nullable
    private final String countProjection;
    private final QueryExtractor extractor;
    private final boolean namedCountQueryIsPresent;

    private NamedQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        boolean cantExtractQuery;
        this.queryName = method.getNamedQueryName();
        this.countQueryName = method.getNamedCountQueryName();
        this.extractor = method.getQueryExtractor();
        this.countProjection = method.getCountQueryProjection();
        JpaParameters parameters = method.getParameters();
        if (parameters.hasSortParameter()) {
            throw new IllegalStateException(String.format("Finder method %s is backed by a NamedQuery and must not contain a sort parameter as we cannot modify the query! Use @Query instead!", method));
        }
        this.namedCountQueryIsPresent = NamedQuery.hasNamedQuery(em, this.countQueryName);
        boolean weNeedToCreateCountQuery = !this.namedCountQueryIsPresent && method.getParameters().hasPageableParameter();
        boolean bl = cantExtractQuery = !this.extractor.canExtractQuery();
        if (weNeedToCreateCountQuery && cantExtractQuery) {
            throw QueryCreationException.create((QueryMethod)method, CANNOT_EXTRACT_QUERY);
        }
        if (parameters.hasPageableParameter()) {
            LOG.warn("Finder method {} is backed by a NamedQuery but contains a Pageable parameter! Sorting delivered via this Pageable will not be applied!", (Object)method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNamedQuery(EntityManager em, String queryName) {
        try (EntityManager lookupEm = em.getEntityManagerFactory().createEntityManager();){
            lookupEm.createNamedQuery(queryName);
            boolean bl = true;
            return bl;
        }
    }

    @Nullable
    public static RepositoryQuery lookupFrom(JpaQueryMethod method, EntityManager em) {
        String queryName = method.getNamedQueryName();
        LOG.debug("Looking up named query {}", (Object)queryName);
        if (!NamedQuery.hasNamedQuery(em, queryName)) {
            return null;
        }
        try {
            NamedQuery query2 = new NamedQuery(method, em);
            LOG.debug("Found named query {}!", (Object)queryName);
            return query2;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    protected Query doCreateQuery(Object[] values) {
        EntityManager em = this.getEntityManager();
        Query query2 = this.getTypeToRead().map(it -> em.createNamedQuery(this.queryName, it)).orElseGet(() -> em.createNamedQuery(this.queryName));
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query2, values);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(Object[] values) {
        TypedQuery<Long> countQuery;
        EntityManager em = this.getEntityManager();
        if (this.namedCountQueryIsPresent) {
            countQuery = em.createNamedQuery(this.countQueryName, Long.class);
        } else {
            Query query2 = this.createQuery(values);
            String queryString = this.extractor.extractQueryString(query2);
            if (queryString == null) {
                throw new IllegalStateException(String.format("Cannot extract query string for query %s is null!", query2));
            }
            countQuery = em.createQuery(QueryUtils.createCountQueryFor(queryString, this.countProjection), Long.class);
        }
        return ((ParameterBinder)this.parameterBinder.get()).bind(countQuery, values, QueryParameterSetter.ErrorHandling.LENIENT);
    }
}

