/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import javax.persistence.TemporalType;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.repository.Temporal;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.lang.Nullable;

public class JpaParameters
extends Parameters<JpaParameters, JpaParameter> {
    public JpaParameters(Method method) {
        super(method);
    }

    private JpaParameters(List<JpaParameter> parameters) {
        super(parameters);
    }

    @Override
    protected JpaParameter createParameter(MethodParameter parameter) {
        return new JpaParameter(parameter);
    }

    @Override
    protected JpaParameters createFrom(List<JpaParameter> parameters) {
        return new JpaParameters(parameters);
    }

    static class JpaParameter
    extends Parameter {
        @Nullable
        private final Temporal annotation;
        @Nullable
        private TemporalType temporalType;

        JpaParameter(MethodParameter parameter) {
            super(parameter);
            this.annotation = parameter.getParameterAnnotation(Temporal.class);
            this.temporalType = null;
            if (!this.isDateParameter() && this.hasTemporalParamAnnotation()) {
                throw new IllegalArgumentException(Temporal.class.getSimpleName() + " annotation is only allowed on Date parameter!");
            }
        }

        @Override
        public boolean isBindable() {
            return super.isBindable() || this.isTemporalParameter();
        }

        boolean isTemporalParameter() {
            return this.isDateParameter() && this.hasTemporalParamAnnotation();
        }

        @Nullable
        TemporalType getTemporalType() {
            if (this.temporalType == null) {
                this.temporalType = this.annotation == null ? null : this.annotation.value();
            }
            return this.temporalType;
        }

        TemporalType getRequiredTemporalType() throws IllegalStateException {
            TemporalType temporalType = this.getTemporalType();
            if (temporalType != null) {
                return temporalType;
            }
            throw new IllegalStateException(String.format("Required temporal type not found for %s!", this.getType()));
        }

        private boolean hasTemporalParamAnnotation() {
            return this.annotation != null;
        }

        private boolean isDateParameter() {
            return this.getType().equals(Date.class);
        }
    }
}

