/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;

class DefaultConverterBuilder<S, T>
implements ConverterBuilder.ConverterAware,
ConverterBuilder.ReadingConverterBuilder<T, S>,
ConverterBuilder.WritingConverterBuilder<S, T> {
    @NonNull
    private final GenericConverter.ConvertiblePair convertiblePair;
    @NonNull
    private final Optional<Function<? super S, ? extends T>> writing;
    @NonNull
    private final Optional<Function<? super T, ? extends S>> reading;

    @Override
    public ConverterBuilder.ConverterAware andReading(Function<? super T, ? extends S> function) {
        return this.withReading(Optional.of(function));
    }

    @Override
    public ConverterBuilder.ConverterAware andWriting(Function<? super S, ? extends T> function) {
        return this.withWriting(Optional.of(function));
    }

    @Override
    public GenericConverter getReadingConverter() {
        return this.getOptionalReadingConverter().orElseThrow(() -> new IllegalStateException("No reading converter specified!"));
    }

    @Override
    public GenericConverter getWritingConverter() {
        return this.getOptionalWritingConverter().orElseThrow(() -> new IllegalStateException("No writing converter specified!"));
    }

    @Override
    public Set<GenericConverter> getConverters() {
        return Optionals.toStream(this.getOptionalReadingConverter(), this.getOptionalWritingConverter()).collect(Collectors.toSet());
    }

    private Optional<GenericConverter> getOptionalReadingConverter() {
        return this.reading.map(it -> new ConfigurableGenericConverter.Reading(this.convertiblePair, it));
    }

    private Optional<GenericConverter> getOptionalWritingConverter() {
        return this.writing.map(it -> new ConfigurableGenericConverter.Writing(this.invertedPair(), it));
    }

    private GenericConverter.ConvertiblePair invertedPair() {
        return new GenericConverter.ConvertiblePair(this.convertiblePair.getTargetType(), this.convertiblePair.getSourceType());
    }

    DefaultConverterBuilder<S, T> withConvertiblePair(@NonNull GenericConverter.ConvertiblePair convertiblePair) {
        if (convertiblePair == null) {
            throw new IllegalArgumentException("convertiblePair is null");
        }
        return this.convertiblePair == convertiblePair ? this : new DefaultConverterBuilder<S, T>(convertiblePair, this.writing, this.reading);
    }

    DefaultConverterBuilder<S, T> withWriting(@NonNull Optional<Function<? super S, ? extends T>> writing) {
        if (writing == null) {
            throw new IllegalArgumentException("writing is null");
        }
        return this.writing == writing ? this : new DefaultConverterBuilder<S, T>(this.convertiblePair, writing, this.reading);
    }

    DefaultConverterBuilder<S, T> withReading(@NonNull Optional<Function<? super T, ? extends S>> reading) {
        if (reading == null) {
            throw new IllegalArgumentException("reading is null");
        }
        return this.reading == reading ? this : new DefaultConverterBuilder<S, T>(this.convertiblePair, this.writing, reading);
    }

    DefaultConverterBuilder(@NonNull GenericConverter.ConvertiblePair convertiblePair, @NonNull Optional<Function<? super S, ? extends T>> writing, @NonNull Optional<Function<? super T, ? extends S>> reading) {
        if (convertiblePair == null) {
            throw new IllegalArgumentException("convertiblePair is null");
        }
        if (writing == null) {
            throw new IllegalArgumentException("writing is null");
        }
        if (reading == null) {
            throw new IllegalArgumentException("reading is null");
        }
        this.convertiblePair = convertiblePair;
        this.writing = writing;
        this.reading = reading;
    }

    private static class ConfigurableGenericConverter<S, T>
    implements GenericConverter {
        private final GenericConverter.ConvertiblePair convertiblePair;
        private final Function<? super S, ? extends T> function;

        @Override
        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.function.apply(source);
        }

        @Override
        @Nonnull
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.convertiblePair);
        }

        public ConfigurableGenericConverter(GenericConverter.ConvertiblePair convertiblePair, Function<? super S, ? extends T> function) {
            this.convertiblePair = convertiblePair;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurableGenericConverter)) {
                return false;
            }
            ConfigurableGenericConverter other = (ConfigurableGenericConverter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GenericConverter.ConvertiblePair this$convertiblePair = this.convertiblePair;
            GenericConverter.ConvertiblePair other$convertiblePair = other.convertiblePair;
            if (this$convertiblePair == null ? other$convertiblePair != null : !((Object)this$convertiblePair).equals(other$convertiblePair)) {
                return false;
            }
            Function<S, T> this$function = this.function;
            Function<? super S, ? extends T> other$function = other.function;
            return !(this$function == null ? other$function != null : !this$function.equals(other$function));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigurableGenericConverter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GenericConverter.ConvertiblePair $convertiblePair = this.convertiblePair;
            result = result * 59 + ($convertiblePair == null ? 43 : ((Object)$convertiblePair).hashCode());
            Function<S, T> $function = this.function;
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            return result;
        }

        @ReadingConverter
        private static class Reading<S, T>
        extends ConfigurableGenericConverter<S, T> {
            Reading(GenericConverter.ConvertiblePair convertiblePair, Function<? super S, ? extends T> function) {
                super(convertiblePair, function);
            }
        }

        @WritingConverter
        private static class Writing<S, T>
        extends ConfigurableGenericConverter<S, T> {
            Writing(GenericConverter.ConvertiblePair convertiblePair, Function<? super S, ? extends T> function) {
                super(convertiblePair, function);
            }
        }
    }
}

