/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Slf4jCurrentTraceContext
extends CurrentTraceContext {
    private static final String LEGACY_EXPORTABLE_NAME = "X-Span-Export";
    private static final String LEGACY_PARENT_ID_NAME = "X-B3-ParentSpanId";
    private static final String LEGACY_TRACE_ID_NAME = "X-B3-TraceId";
    private static final String LEGACY_SPAN_ID_NAME = "X-B3-SpanId";
    private static final Logger log = LoggerFactory.getLogger(Slf4jCurrentTraceContext.class);
    final CurrentTraceContext delegate;

    public static Slf4jCurrentTraceContext create() {
        return Slf4jCurrentTraceContext.create(CurrentTraceContext.Default.inheritable());
    }

    public static Slf4jCurrentTraceContext create(CurrentTraceContext delegate) {
        return new Slf4jCurrentTraceContext(delegate);
    }

    Slf4jCurrentTraceContext(CurrentTraceContext delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    @Override
    public TraceContext get() {
        return this.delegate.get();
    }

    @Override
    public CurrentTraceContext.Scope newScope(final @Nullable TraceContext currentSpan) {
        final String previousTraceId = MDC.get("traceId");
        final String previousParentId = MDC.get("parentId");
        final String previousSpanId = MDC.get("spanId");
        final String spanExportable = MDC.get("spanExportable");
        final String legacyPreviousTraceId = MDC.get(LEGACY_TRACE_ID_NAME);
        final String legacyPreviousParentId = MDC.get(LEGACY_PARENT_ID_NAME);
        final String legacyPreviousSpanId = MDC.get(LEGACY_SPAN_ID_NAME);
        final String legacySpanExportable = MDC.get(LEGACY_EXPORTABLE_NAME);
        if (currentSpan != null) {
            String traceIdString = currentSpan.traceIdString();
            MDC.put("traceId", traceIdString);
            MDC.put(LEGACY_TRACE_ID_NAME, traceIdString);
            String parentId = currentSpan.parentId() != null ? HexCodec.toLowerHex(currentSpan.parentId()) : null;
            Slf4jCurrentTraceContext.replace("parentId", parentId);
            Slf4jCurrentTraceContext.replace(LEGACY_PARENT_ID_NAME, parentId);
            String spanId = HexCodec.toLowerHex(currentSpan.spanId());
            MDC.put("spanId", spanId);
            MDC.put(LEGACY_SPAN_ID_NAME, spanId);
            String sampled = String.valueOf(currentSpan.sampled());
            MDC.put("spanExportable", sampled);
            MDC.put(LEGACY_EXPORTABLE_NAME, sampled);
            this.log("Starting scope for span: {}", currentSpan);
            if (currentSpan.parentId() != null && log.isTraceEnabled()) {
                log.trace("With parent: {}", (Object)currentSpan.parentId());
            }
        } else {
            MDC.remove("traceId");
            MDC.remove("parentId");
            MDC.remove("spanId");
            MDC.remove("spanExportable");
            MDC.remove(LEGACY_TRACE_ID_NAME);
            MDC.remove(LEGACY_PARENT_ID_NAME);
            MDC.remove(LEGACY_SPAN_ID_NAME);
            MDC.remove(LEGACY_EXPORTABLE_NAME);
        }
        final CurrentTraceContext.Scope scope = this.delegate.newScope(currentSpan);
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            @Override
            public void close() {
                Slf4jCurrentTraceContext.this.log("Closing scope for span: {}", currentSpan);
                scope.close();
                Slf4jCurrentTraceContext.replace("traceId", previousTraceId);
                Slf4jCurrentTraceContext.replace("parentId", previousParentId);
                Slf4jCurrentTraceContext.replace("spanId", previousSpanId);
                Slf4jCurrentTraceContext.replace("spanExportable", spanExportable);
                Slf4jCurrentTraceContext.replace(Slf4jCurrentTraceContext.LEGACY_TRACE_ID_NAME, legacyPreviousTraceId);
                Slf4jCurrentTraceContext.replace(Slf4jCurrentTraceContext.LEGACY_PARENT_ID_NAME, legacyPreviousParentId);
                Slf4jCurrentTraceContext.replace(Slf4jCurrentTraceContext.LEGACY_SPAN_ID_NAME, legacyPreviousSpanId);
                Slf4jCurrentTraceContext.replace(Slf4jCurrentTraceContext.LEGACY_EXPORTABLE_NAME, legacySpanExportable);
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    private void log(String text, TraceContext span) {
        if (span == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace(text, (Object)span);
        }
    }

    static void replace(String key, @Nullable String value) {
        if (value != null) {
            MDC.put(key, value);
        } else {
            MDC.remove(key);
        }
    }
}

