/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import java.util.regex.Pattern;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthWebProperties.class})
public class TraceWebAutoConfiguration {
    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties"})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    public SkipPatternProvider defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
        return TraceWebAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern(), sleuthWebProperties.getAdditionalSkipPattern());
    }

    private static SkipPatternProvider defaultSkipPatternProvider(String skipPattern, String additionalSkipPattern) {
        return () -> TraceWebAutoConfiguration.defaultSkipPattern(skipPattern, additionalSkipPattern);
    }

    private static Pattern defaultSkipPattern(String skipPattern, String additionalSkipPattern) {
        return Pattern.compile(TraceWebAutoConfiguration.combinedPattern(skipPattern, additionalSkipPattern));
    }

    private static String combinedPattern(String skipPattern, String additionalSkipPattern) {
        String pattern = skipPattern;
        if (!StringUtils.hasText(skipPattern)) {
            pattern = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream|/application/.*|/actuator.*|/cloudfoundryapplication";
        }
        if (StringUtils.hasText(additionalSkipPattern)) {
            return pattern + "|" + additionalSkipPattern;
        }
        return pattern;
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    @EnableConfigurationProperties(value={SleuthWebProperties.class})
    protected static class SkipPatternProviderConfig {
        protected SkipPatternProviderConfig() {
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SkipPatternProvider skipPatternForManagementServerProperties(final ManagementServerProperties managementServerProperties, final SleuthWebProperties sleuthWebProperties) {
            return new SkipPatternProvider(){

                @Override
                public Pattern skipPattern() {
                    return SkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties, sleuthWebProperties);
                }
            };
        }

        static Pattern getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties, SleuthWebProperties sleuthWebProperties) {
            String skipPattern = sleuthWebProperties.getSkipPattern();
            String additionalSkipPattern = sleuthWebProperties.getAdditionalSkipPattern();
            String contextPath = managementServerProperties.getServlet().getContextPath();
            if (StringUtils.hasText(skipPattern) && StringUtils.hasText(contextPath)) {
                return Pattern.compile(TraceWebAutoConfiguration.combinedPattern(skipPattern + "|" + contextPath + ".*", additionalSkipPattern));
            }
            if (StringUtils.hasText(contextPath)) {
                return Pattern.compile(TraceWebAutoConfiguration.combinedPattern(contextPath + ".*", additionalSkipPattern));
            }
            return TraceWebAutoConfiguration.defaultSkipPattern(skipPattern, additionalSkipPattern);
        }

        @Bean
        @ConditionalOnMissingBean(value={ManagementServerProperties.class})
        public SkipPatternProvider defaultSkipPatternBeanIfManagementServerPropsArePresent(SleuthWebProperties sleuthWebProperties) {
            return TraceWebAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern(), sleuthWebProperties.getAdditionalSkipPattern());
        }
    }
}

