/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.ThreadLocalSpan;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagation;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;

public final class TracingChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor {
    private static final Log log = LogFactory.getLog(TracingChannelInterceptor.class);
    private static final String REMOTE_SERVICE_NAME = "broker";
    final Tracing tracing;
    final Tracer tracer;
    final ThreadLocalSpan threadLocalSpan;
    final TraceContext.Injector<MessageHeaderAccessor> injector;
    final TraceContext.Extractor<MessageHeaderAccessor> extractor;
    final boolean integrationObjectSupportPresent;
    private final boolean hasDirectChannelClass;

    public static TracingChannelInterceptor create(Tracing tracing) {
        return new TracingChannelInterceptor(tracing);
    }

    TracingChannelInterceptor(Tracing tracing) {
        this.tracing = tracing;
        this.tracer = tracing.tracer();
        this.threadLocalSpan = ThreadLocalSpan.create(this.tracer);
        this.injector = tracing.propagation().injector(MessageHeaderPropagation.INSTANCE);
        this.extractor = tracing.propagation().extractor(MessageHeaderPropagation.INSTANCE);
        this.integrationObjectSupportPresent = ClassUtils.isPresent("org.springframework.integration.context.IntegrationObjectSupport", null);
        this.hasDirectChannelClass = ClassUtils.isPresent("org.springframework.integration.channel.DirectChannel", null);
    }

    public Span nextSpan(Message<?> message) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract(headers);
        headers.setImmutable();
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            this.addTags(message, result, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created a new span " + result);
        }
        return result;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        Message<?> retrievedMessage = this.getMessage(message);
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(retrievedMessage);
        TraceContextOrSamplingFlags extracted = this.extractor.extract(headers);
        Span span = this.threadLocalSpan.next(extracted);
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        this.injector.inject(span.context(), headers);
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("send").start();
            span.remoteServiceName(REMOTE_SERVICE_NAME);
            this.addTags(message, span, channel);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created a new span in pre send" + span);
        }
        Message<?> outputMessage = this.outputMessage(message, retrievedMessage, headers);
        if (this.isDirectChannel(channel)) {
            this.beforeHandle(outputMessage, channel, null);
        }
        return outputMessage;
    }

    private Message<?> outputMessage(Message<?> originalMessage, Message<?> retrievedMessage, MessageHeaderAccessor additionalHeaders) {
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(originalMessage);
        if (originalMessage.getPayload() instanceof MessagingException) {
            headers.copyHeaders(MessageHeaderPropagation.propagationHeaders(additionalHeaders.getMessageHeaders(), this.tracing.propagation().keys()));
            return new ErrorMessage((Throwable)((MessagingException)originalMessage.getPayload()), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
        }
        headers.copyHeaders((Map)additionalHeaders.getMessageHeaders());
        return new GenericMessage(retrievedMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
    }

    private boolean isWebSockets(MessageHeaderAccessor headerAccessor) {
        return headerAccessor.getMessageHeaders().containsKey((Object)"stompCommand") || headerAccessor.getMessageHeaders().containsKey((Object)"simpMessageType");
    }

    private boolean isDirectChannel(MessageChannel channel) {
        return this.hasDirectChannelClass && DirectChannel.class.isAssignableFrom(AopUtils.getTargetClass(channel));
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (this.isDirectChannel(channel)) {
            this.afterMessageHandled(message, channel, null, ex);
        }
        if (log.isDebugEnabled()) {
            log.debug("Will finish the current span after completion " + this.tracer.currentSpan());
        }
        this.finishSpan(ex);
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract(headers);
        Span span = this.threadLocalSpan.next(extracted);
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        this.injector.inject(span.context(), headers);
        if (!span.isNoop()) {
            span.kind(Span.Kind.CONSUMER).name("receive").start();
            span.remoteServiceName(REMOTE_SERVICE_NAME);
            this.addTags(message, span, channel);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created a new span in post receive " + span);
        }
        headers.setImmutable();
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Will finish the current span after receive completion " + this.tracer.currentSpan());
        }
        this.finishSpan(ex);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        TraceContextOrSamplingFlags extracted = this.extractor.extract(headers);
        Span consumerSpan = this.tracer.nextSpan(extracted);
        if (!consumerSpan.isNoop()) {
            consumerSpan.kind(Span.Kind.CONSUMER).start();
            consumerSpan.remoteServiceName(REMOTE_SERVICE_NAME);
            this.addTags(message, consumerSpan, channel);
            consumerSpan.finish();
        }
        this.threadLocalSpan.next(TraceContextOrSamplingFlags.create(consumerSpan.context())).name("handle").start();
        MessageHeaderPropagation.removeAnyTraceHeaders(headers, this.tracing.propagation().keys());
        if (log.isDebugEnabled()) {
            log.debug("Created a new span in before handle" + consumerSpan);
        }
        if (message instanceof ErrorMessage) {
            return new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders());
        }
        headers.setImmutable();
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Will finish the current span after message handled " + this.tracer.currentSpan());
        }
        this.finishSpan(ex);
    }

    void addTags(Message<?> message, SpanCustomizer result, MessageChannel channel) {
        if (channel != null) {
            result.tag("channel", this.messageChannelName(channel));
        }
    }

    private String channelName(MessageChannel channel) {
        String name = null;
        if (this.integrationObjectSupportPresent) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            name = channel.toString();
        }
        return name;
    }

    private String messageChannelName(MessageChannel channel) {
        return SpanNameUtil.shorten(this.channelName(channel));
    }

    void finishSpan(Exception error) {
        Span span = this.threadLocalSpan.remove();
        if (span == null || span.isNoop()) {
            return;
        }
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.tag("error", message);
        }
        span.finish();
    }

    private MessageHeaderAccessor mutableHeaderAccessor(Message<?> message) {
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.setLeaveMutable(true);
        return headers;
    }

    private Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            Message<?> failedMessage = e.getFailedMessage();
            return failedMessage != null ? failedMessage : message;
        }
        return message;
    }

    private boolean emptyMessage(Message<?> message) {
        return message == null;
    }
}

