/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.propagation.Propagation;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

enum MessageHeaderPropagation implements Propagation.Setter<MessageHeaderAccessor, String>,
Propagation.Getter<MessageHeaderAccessor, String>
{
    INSTANCE;

    private static final Log log;
    private static final Map<String, String> LEGACY_HEADER_MAPPING;
    private static final String TRACE_ID_NAME = "X-B3-TraceId";
    private static final String SPAN_ID_NAME = "X-B3-SpanId";
    private static final String PARENT_SPAN_ID_NAME = "X-B3-ParentSpanId";
    private static final String SAMPLED_NAME = "X-B3-Sampled";
    private static final String FLAGS_NAME = "X-B3-Flags";

    @Override
    public void put(MessageHeaderAccessor accessor, String key, String value) {
        block3: {
            try {
                this.doPut(accessor, key, value);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("An exception happened when we tried to retrieve the [" + key + "] from message", e);
            }
        }
        String legacyKey = LEGACY_HEADER_MAPPING.get(key);
        if (legacyKey != null) {
            this.doPut(accessor, legacyKey, value);
        }
    }

    private void doPut(MessageHeaderAccessor accessor, String key, String value) {
        accessor.setHeader(key, (Object)value);
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            nativeAccessor.setNativeHeader(key, value);
        } else {
            LinkedMultiValueMap nativeHeaders = accessor.getHeader("nativeHeaders");
            if (nativeHeaders == null) {
                nativeHeaders = new LinkedMultiValueMap();
                accessor.setHeader("nativeHeaders", nativeHeaders);
            }
            if (nativeHeaders instanceof Map) {
                Map<String, List<String>> copy = this.toNativeHeaderMap(nativeHeaders);
                copy.put(key, Collections.singletonList(value));
                accessor.setHeader("nativeHeaders", copy);
            }
        }
    }

    private Map<String, List<String>> toNativeHeaderMap(Map<String, List<String>> map) {
        return map != null ? new LinkedMultiValueMap<String, String>(map) : Collections.emptyMap();
    }

    @Override
    public String get(MessageHeaderAccessor accessor, String key) {
        block3: {
            try {
                String value = this.doGet(accessor, key);
                if (StringUtils.hasText(value)) {
                    return value;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("An exception happened when we tried to retrieve the [" + key + "] from message", e);
            }
        }
        return this.legacyValue(accessor, key);
    }

    private String legacyValue(MessageHeaderAccessor accessor, String key) {
        String legacyKey = LEGACY_HEADER_MAPPING.get(key);
        if (legacyKey != null) {
            return this.doGet(accessor, legacyKey);
        }
        return null;
    }

    private String doGet(MessageHeaderAccessor accessor, String key) {
        Object result;
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            String result2 = nativeAccessor.getFirstNativeHeader(key);
            if (result2 != null) {
                return result2;
            }
        } else {
            Object result3;
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (nativeHeaders instanceof Map && (result3 = ((Map)nativeHeaders).get(key)) instanceof List && !((List)result3).isEmpty()) {
                return String.valueOf(((List)result3).get(0));
            }
        }
        if ((result = accessor.getHeader(key)) != null) {
            if (result instanceof byte[]) {
                return new String((byte[])result, StandardCharsets.UTF_8);
            }
            return result.toString();
        }
        return null;
    }

    static Map<String, ?> propagationHeaders(Map<String, ?> headers, List<String> propagationHeaders) {
        HashMap headersToCopy = new HashMap();
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            if (!propagationHeaders.contains(entry.getKey())) continue;
            headersToCopy.put(entry.getKey(), entry.getValue());
        }
        return headersToCopy;
    }

    static void removeAnyTraceHeaders(MessageHeaderAccessor accessor, List<String> keysToRemove) {
        for (String keyToRemove : keysToRemove) {
            accessor.removeHeader(keyToRemove);
            if (accessor instanceof NativeMessageHeaderAccessor) {
                NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
                nativeAccessor.removeNativeHeader(keyToRemove);
                continue;
            }
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (!(nativeHeaders instanceof Map)) continue;
            ((Map)nativeHeaders).remove(keyToRemove);
        }
    }

    public String toString() {
        return "MessageHeaderPropagation{}";
    }

    static {
        log = LogFactory.getLog(MessageHeaderPropagation.class);
        LEGACY_HEADER_MAPPING = new HashMap<String, String>();
        LEGACY_HEADER_MAPPING.put(TRACE_ID_NAME, "spanTraceId");
        LEGACY_HEADER_MAPPING.put(SPAN_ID_NAME, "spanId");
        LEGACY_HEADER_MAPPING.put(PARENT_SPAN_ID_NAME, "spanParentSpanId");
        LEGACY_HEADER_MAPPING.put(SAMPLED_NAME, "spanSampled");
        LEGACY_HEADER_MAPPING.put(FLAGS_NAME, "spanFlags");
    }
}

