/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.hystrix;

import brave.Span;
import brave.Tracer;
import com.netflix.hystrix.HystrixCommand;

public abstract class TraceCommand<R>
extends HystrixCommand<R> {
    private static final String COMMAND_KEY = "commandKey";
    private static final String COMMAND_GROUP_KEY = "commandGroup";
    private static final String THREAD_POOL_KEY = "threadPoolKey";
    private final Tracer tracer;
    private final Span span;

    protected TraceCommand(Tracer tracer, HystrixCommand.Setter setter) {
        super(setter);
        this.tracer = tracer;
        this.span = this.tracer.nextSpan();
    }

    /*
     * Loose catch block
     */
    protected R run() throws Exception {
        String commandKeyName = this.getCommandKey().name();
        Span span = this.span.name(commandKeyName);
        span.tag(COMMAND_KEY, commandKeyName);
        span.tag(COMMAND_GROUP_KEY, this.getCommandGroup().name());
        span.tag(THREAD_POOL_KEY, this.getThreadPoolKey().name());
        try {
            R r;
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span.start());){
                r = this.doRun();
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    public abstract R doRun() throws Exception;
}

