/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;

public class TraceableExecutorService
implements ExecutorService {
    final ExecutorService delegate;
    private final String spanName;
    Tracing tracing;
    SpanNamer spanNamer;
    BeanFactory beanFactory;

    public TraceableExecutorService(BeanFactory beanFactory, ExecutorService delegate) {
        this(beanFactory, delegate, null);
    }

    public TraceableExecutorService(BeanFactory beanFactory, ExecutorService delegate, String spanName) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
        this.spanName = spanName;
    }

    @Override
    public void execute(Runnable command) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), command, this.spanName);
        this.delegate.execute(r);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        TraceCallable<T> c = new TraceCallable<T>(this.tracing(), this.spanNamer(), task, this.spanName);
        return this.delegate.submit(c);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), task, this.spanName);
        return this.delegate.submit(r, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        TraceRunnable r = new TraceRunnable(this.tracing(), this.spanNamer(), task, this.spanName);
        return this.delegate.submit(r);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapCallableCollection(tasks), timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<TraceCallable<T>> ts = new ArrayList<TraceCallable<T>>();
        for (Callable<T> task : tasks) {
            if (task instanceof TraceCallable) continue;
            ts.add(new TraceCallable<T>(this.tracing(), this.spanNamer(), task, this.spanName));
        }
        return ts;
    }

    Tracing tracing() {
        if (this.tracing == null && this.beanFactory != null) {
            this.tracing = this.beanFactory.getBean(Tracing.class);
        }
        return this.tracing;
    }

    SpanNamer spanNamer() {
        if (this.spanNamer == null && this.beanFactory != null) {
            this.spanNamer = this.beanFactory.getBean(SpanNamer.class);
        }
        return this.spanNamer;
    }
}

