/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.ExecutorMethodInterceptor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceScheduledThreadPoolExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskScheduler;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ReflectionUtils;

class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(ExecutorBeanPostProcessor.class);
    private final BeanFactory beanFactory;

    ExecutorBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof ThreadPoolTaskExecutor) {
            return this.wrapThreadPoolTaskExecutor(bean2);
        }
        if (bean2 instanceof ExecutorService) {
            return this.wrapExecutorService(bean2);
        }
        if (bean2 instanceof Executor) {
            return this.wrapExecutor(bean2);
        }
        return bean2;
    }

    private Object wrapExecutor(Object bean2) {
        Method execute = ReflectionUtils.findMethod(bean2.getClass(), "execute", Runnable.class);
        boolean methodFinal = Modifier.isFinal(execute.getModifiers());
        boolean classFinal = Modifier.isFinal(bean2.getClass().getModifiers());
        boolean cglibProxy = !methodFinal && !classFinal;
        Executor executor = (Executor)bean2;
        try {
            return this.createProxy(bean2, cglibProxy, new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception occurred while trying to create a proxy, falling back to JDK proxy", ex);
                }
                return this.createProxy(bean2, false, new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory));
            }
            throw ex;
        }
    }

    private Object wrapThreadPoolTaskExecutor(Object bean2) {
        boolean classFinal = Modifier.isFinal(bean2.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean2;
        return this.createThreadPoolTaskExecutorProxy(bean2, cglibProxy, executor);
    }

    private ProxyFactoryBean wrapThreadPoolTaskScheduler(Object bean2) {
        boolean classFinal = Modifier.isFinal(bean2.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ThreadPoolTaskScheduler executor = (ThreadPoolTaskScheduler)bean2;
        return this.proxyFactoryBean(bean2, cglibProxy, executor, this.createThreadPoolTaskSchedulerProxy(executor));
    }

    private ProxyFactoryBean wrapScheduledThreadPoolExecutor(Object bean2) {
        boolean classFinal = Modifier.isFinal(bean2.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)bean2;
        return this.proxyFactoryBean(bean2, cglibProxy, executor, this.createScheduledThreadPoolExecutorProxy(executor));
    }

    private Object wrapExecutorService(Object bean2) {
        boolean classFinal = Modifier.isFinal(bean2.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        ExecutorService executor = (ExecutorService)bean2;
        return this.createExecutorServiceProxy(bean2, cglibProxy, executor);
    }

    Object createThreadPoolTaskExecutorProxy(Object bean2, boolean cglibProxy, ThreadPoolTaskExecutor executor) {
        return this.getProxiedObject(bean2, cglibProxy, executor, () -> new LazyTraceThreadPoolTaskExecutor(this.beanFactory, executor));
    }

    Supplier createThreadPoolTaskSchedulerProxy(ThreadPoolTaskScheduler executor) {
        return () -> new LazyTraceThreadPoolTaskScheduler(this.beanFactory, executor);
    }

    Supplier createScheduledThreadPoolExecutorProxy(ScheduledThreadPoolExecutor executor) {
        return () -> new LazyTraceScheduledThreadPoolExecutor(executor.getCorePoolSize(), executor.getThreadFactory(), executor.getRejectedExecutionHandler(), this.beanFactory, executor);
    }

    Object createExecutorServiceProxy(Object bean2, boolean cglibProxy, ExecutorService executor) {
        return this.getProxiedObject(bean2, cglibProxy, executor, () -> new TraceableExecutorService(this.beanFactory, executor));
    }

    private Object getProxiedObject(Object bean2, boolean cglibProxy, Executor executor, Supplier<Executor> supplier) {
        ProxyFactoryBean factory = this.proxyFactoryBean(bean2, cglibProxy, executor, supplier);
        try {
            return this.getObject(factory);
        }
        catch (Exception ex) {
            block9: {
                if (log.isDebugEnabled()) {
                    log.debug("Exception occurred while trying to get a proxy. Will fallback to a different implementation", ex);
                }
                try {
                    if (bean2 instanceof ThreadPoolTaskScheduler) {
                        if (log.isDebugEnabled()) {
                            log.debug("Will wrap ThreadPoolTaskScheduler in its tracing representation due to previous errors");
                        }
                        return this.createThreadPoolTaskSchedulerProxy((ThreadPoolTaskScheduler)bean2).get();
                    }
                    if (bean2 instanceof ScheduledThreadPoolExecutor) {
                        if (log.isDebugEnabled()) {
                            log.debug("Will wrap ScheduledThreadPoolExecutor in its tracing representation due to previous errors");
                        }
                        return this.createScheduledThreadPoolExecutorProxy((ScheduledThreadPoolExecutor)bean2).get();
                    }
                }
                catch (Exception ex2) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug("Fallback for special wrappers failed, will try the tracing representation instead", ex2);
                }
            }
            return supplier.get();
        }
    }

    private ProxyFactoryBean proxyFactoryBean(Object bean2, boolean cglibProxy, Executor executor, final Supplier<Executor> supplier) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory){

            @Override
            <T extends Executor> T executor(BeanFactory beanFactory, T executor) {
                return (T)((Executor)supplier.get());
            }
        });
        factory.setTarget(bean2);
        return factory;
    }

    Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    Object createProxy(Object bean2, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean2);
        return factory.getObject();
    }
}

