/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import brave.Span;
import brave.Tracer;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.annotation.SpanTagAnnotationHandler;

class SleuthInterceptor
implements IntroductionInterceptor,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(SleuthInterceptor.class);
    private static final String CLASS_KEY = "class";
    private static final String METHOD_KEY = "method";
    private BeanFactory beanFactory;
    private NewSpanParser newSpanParser;
    private Tracer tracer;
    private SpanTagAnnotationHandler spanTagAnnotationHandler;

    SleuthInterceptor() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addTags(MethodInvocation invocation, Span span) {
        span.tag(CLASS_KEY, invocation.getThis().getClass().getSimpleName());
        span.tag(METHOD_KEY, invocation.getMethod().getName());
    }

    private void logEvent(Span span, String name) {
        if (span == null) {
            logger.warn("You were trying to continue a span which was null. Please remember that if two proxied methods are calling each other from the same class then the aspect will not be properly resolved");
            return;
        }
        span.annotate(name);
    }

    private String log(ContinueSpan continueSpan) {
        if (continueSpan != null) {
            return continueSpan.log();
        }
        return "";
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private NewSpanParser newSpanParser() {
        if (this.newSpanParser == null) {
            this.newSpanParser = this.beanFactory.getBean(NewSpanParser.class);
        }
        return this.newSpanParser;
    }

    private SpanTagAnnotationHandler spanTagAnnotationHandler() {
        if (this.spanTagAnnotationHandler == null) {
            this.spanTagAnnotationHandler = new SpanTagAnnotationHandler(this.beanFactory);
        }
        return this.spanTagAnnotationHandler;
    }

    @Override
    public boolean implementsInterface(Class<?> intf) {
        return true;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

