/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration
@Import(value={UtilAutoConfiguration.class})
@EnableDiscoveryClient
public class DiscoveryClientConfigServiceBootstrapConfiguration {
    private static Log logger = LogFactory.getLog(DiscoveryClientConfigServiceBootstrapConfiguration.class);
    @Autowired
    private ConfigClientProperties config;
    @Autowired
    private ConfigServerInstanceProvider instanceProvider;
    private HeartbeatMonitor monitor = new HeartbeatMonitor();

    @Bean
    public ConfigServerInstanceProvider configServerInstanceProvider(DiscoveryClient discoveryClient) {
        return new ConfigServerInstanceProvider(discoveryClient);
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void startup(ContextRefreshedEvent event) {
        this.refresh();
    }

    @EventListener(value={HeartbeatEvent.class})
    public void heartbeat(HeartbeatEvent event) {
        if (this.monitor.update(event.getValue())) {
            this.refresh();
        }
    }

    private void refresh() {
        try {
            String serviceId = this.config.getDiscovery().getServiceId();
            ArrayList<String> listOfUrls = new ArrayList<String>();
            List<ServiceInstance> serviceInstances = this.instanceProvider.getConfigServerInstances(serviceId);
            for (int i = 0; i < serviceInstances.size(); ++i) {
                ServiceInstance server = serviceInstances.get(i);
                String url = this.getHomePage(server);
                if (server.getMetadata().containsKey("password")) {
                    String user = server.getMetadata().get("user");
                    user = user == null ? "user" : user;
                    this.config.setUsername(user);
                    String password = server.getMetadata().get("password");
                    this.config.setPassword(password);
                }
                if (server.getMetadata().containsKey("configPath")) {
                    String path = server.getMetadata().get("configPath");
                    if (url.endsWith("/") && path.startsWith("/")) {
                        url = url.substring(0, url.length() - 1);
                    }
                    url = url + path;
                }
                listOfUrls.add(url);
            }
            String[] uri = new String[listOfUrls.size()];
            uri = listOfUrls.toArray(uri);
            this.config.setUri(uri);
        }
        catch (Exception ex) {
            if (this.config.isFailFast()) {
                throw ex;
            }
            logger.warn("Could not locate configserver via discovery", ex);
        }
    }

    private String getHomePage(ServiceInstance server) {
        return server.getUri().toString() + "/";
    }
}

