/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryException;

public abstract class LoadBalancedRecoveryCallback<T, R>
implements RecoveryCallback<T> {
    protected abstract T createResponse(R var1, URI var2);

    @Override
    public T recover(RetryContext context) throws Exception {
        Throwable lastThrowable = context.getLastThrowable();
        if (lastThrowable != null) {
            if (lastThrowable instanceof RetryableStatusCodeException) {
                RetryableStatusCodeException ex = (RetryableStatusCodeException)lastThrowable;
                return this.createResponse(ex.getResponse(), ex.getUri());
            }
            if (lastThrowable instanceof Exception) {
                throw (Exception)lastThrowable;
            }
        }
        throw new RetryException("Could not recover", lastThrowable);
    }
}

