/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String DECRYPTED_PROPERTY_SOURCE_NAME = "decrypted";
    public static final String DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME = "decryptedBootstrap";
    private int order = -2147483633;
    private static Log logger = LogFactory.getLog(EnvironmentDecryptApplicationInitializer.class);
    private TextEncryptor encryptor;
    private boolean failOnError = true;
    private static final Pattern COLLECTION_PROPERTY = Pattern.compile("(\\S+)?\\[(\\d+)\\](\\.\\S+)?");

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ApplicationContext parent;
        PropertySource<?> bootstrap;
        ConfigurableEnvironment environment2 = applicationContext.getEnvironment();
        MutablePropertySources propertySources = environment2.getPropertySources();
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        Map<String, Object> map = this.decrypt(propertySources);
        if (!map.isEmpty()) {
            found.addAll(map.keySet());
            this.insert(applicationContext, new SystemEnvironmentPropertySource(DECRYPTED_PROPERTY_SOURCE_NAME, map));
        }
        if ((bootstrap = propertySources.get("bootstrap")) != null && !(map = this.decrypt(bootstrap)).isEmpty()) {
            found.addAll(map.keySet());
            this.insert(applicationContext, new SystemEnvironmentPropertySource(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME, map));
        }
        if (!found.isEmpty() && (parent = applicationContext.getParent()) != null) {
            parent.publishEvent(new EnvironmentChangeEvent(parent, found));
        }
    }

    private void insert(ApplicationContext applicationContext, PropertySource<?> propertySource) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ConfigurableEnvironment mutable = (ConfigurableEnvironment)parent.getEnvironment();
            this.insert(mutable.getPropertySources(), propertySource);
        }
    }

    private void insert(MutablePropertySources propertySources, PropertySource<?> propertySource) {
        if (propertySources.contains("bootstrap")) {
            if (DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME.equals(propertySource.getName())) {
                propertySources.addBefore("bootstrap", propertySource);
            } else {
                propertySources.addAfter("bootstrap", propertySource);
            }
        } else {
            propertySources.addFirst(propertySource);
        }
    }

    public Map<String, Object> decrypt(PropertySources propertySources) {
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (PropertySource source : propertySources) {
            sources.add(0, source);
        }
        for (PropertySource source : sources) {
            this.decrypt(source, overrides);
        }
        return overrides;
    }

    private Map<String, Object> decrypt(PropertySource<?> source) {
        LinkedHashMap<String, Object> overrides = new LinkedHashMap<String, Object>();
        this.decrypt(source, overrides);
        return overrides;
    }

    private void decrypt(PropertySource<?> source, Map<String, Object> overrides) {
        if (source instanceof EnumerablePropertySource) {
            LinkedHashMap<String, String> otherCollectionProperties = new LinkedHashMap<String, String>();
            boolean sourceHasDecryptedCollection = false;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String key : enumerable.getPropertyNames()) {
                Object property = source.getProperty(key);
                if (property == null) continue;
                String value = property.toString();
                if (value.startsWith("{cipher}")) {
                    value = value.substring("{cipher}".length());
                    try {
                        value = this.encryptor.decrypt(value);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Decrypted: key=" + key);
                        }
                    }
                    catch (Exception e) {
                        String message = "Cannot decrypt: key=" + key;
                        if (this.failOnError) {
                            throw new IllegalStateException(message, e);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.warn(message, e);
                        } else {
                            logger.warn(message);
                        }
                        value = "";
                    }
                    overrides.put(key, value);
                    if (!COLLECTION_PROPERTY.matcher(key).matches()) continue;
                    sourceHasDecryptedCollection = true;
                    continue;
                }
                if (!COLLECTION_PROPERTY.matcher(key).matches()) continue;
                otherCollectionProperties.put(key, value);
            }
            if (sourceHasDecryptedCollection && !otherCollectionProperties.isEmpty()) {
                overrides.putAll(otherCollectionProperties);
            }
        } else if (source instanceof CompositePropertySource) {
            for (PropertySource<?> nested : ((CompositePropertySource)source).getPropertySources()) {
                this.decrypt(nested, overrides);
            }
        }
    }
}

