/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    private int order = -2147483638;
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        CompositePropertySource composite = new CompositePropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        ConfigurableEnvironment environment2 = applicationContext.getEnvironment();
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            PropertySource<?> source = null;
            source = locator.locate(environment2);
            if (source == null) continue;
            logger.info("Located property source: " + source);
            composite.addPropertySource(source);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = environment2.getPropertySources();
            String logConfig = environment2.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get(environment2);
            if (propertySources.contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
                propertySources.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
            }
            this.insertPropertySources(propertySources, composite);
            this.reinitializeLoggingSystem(environment2, logConfig, logFile);
            this.setLogLevels(applicationContext, environment2);
            this.handleIncludedProfiles(environment2);
        }
    }

    private void reinitializeLoggingSystem(ConfigurableEnvironment environment2, String oldLogConfig, LogFile oldLogFile) {
        Map props = Binder.get(environment2).bind("logging", Bindable.mapOf(String.class, Object.class)).orElseGet(Collections::emptyMap);
        if (!props.isEmpty()) {
            String logConfig = environment2.resolvePlaceholders("${logging.config:}");
            LogFile logFile = LogFile.get(environment2);
            LoggingSystem system = LoggingSystem.get(LoggingSystem.class.getClassLoader());
            try {
                ResourceUtils.getURL(logConfig).openStream().close();
                system.cleanUp();
                system.beforeInitialize();
                system.initialize(new LoggingInitializationContext(environment2), logConfig, logFile);
            }
            catch (Exception ex) {
                logger.warn("Error opening logging config file " + logConfig, ex);
            }
        }
    }

    private void setLogLevels(ConfigurableApplicationContext applicationContext, ConfigurableEnvironment environment2) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment(environment2);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent(applicationContext, Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, CompositePropertySource composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        incoming.addFirst(composite);
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        Binder.get(this.environment(incoming)).bind("spring.cloud.config", Bindable.ofInstance(remoteProperties));
        if (!remoteProperties.isAllowOverride() || !remoteProperties.isOverrideNone() && remoteProperties.isOverrideSystemProperties()) {
            propertySources.addFirst(composite);
            return;
        }
        if (remoteProperties.isOverrideNone()) {
            propertySources.addLast(composite);
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            if (!remoteProperties.isOverrideSystemProperties()) {
                propertySources.addAfter("systemEnvironment", composite);
            } else {
                propertySources.addBefore("systemEnvironment", composite);
            }
        } else {
            propertySources.addLast(composite);
        }
    }

    private Environment environment(MutablePropertySources incoming) {
        StandardEnvironment environment2 = new StandardEnvironment();
        for (PropertySource<?> source : environment2.getPropertySources()) {
            environment2.getPropertySources().remove(source.getName());
        }
        for (PropertySource<?> source : incoming) {
            environment2.getPropertySources().addLast(source);
        }
        return environment2;
    }

    private void handleIncludedProfiles(ConfigurableEnvironment environment2) {
        TreeSet<String> includeProfiles = new TreeSet<String>();
        for (PropertySource<?> propertySource : environment2.getPropertySources()) {
            this.addIncludedProfilesTo(includeProfiles, propertySource);
        }
        ArrayList<String> activeProfiles = new ArrayList<String>();
        Collections.addAll(activeProfiles, environment2.getActiveProfiles());
        includeProfiles.removeAll(activeProfiles);
        if (includeProfiles.isEmpty()) {
            return;
        }
        for (String profile2 : includeProfiles) {
            activeProfiles.add(0, profile2);
        }
        environment2.setActiveProfiles(activeProfiles.toArray(new String[activeProfiles.size()]));
    }

    private Set<String> addIncludedProfilesTo(Set<String> profiles, PropertySource<?> propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            for (PropertySource<?> nestedPropertySource : ((CompositePropertySource)propertySource).getPropertySources()) {
                this.addIncludedProfilesTo(profiles, nestedPropertySource);
            }
        } else {
            Collections.addAll(profiles, this.getProfilesForValue(propertySource.getProperty("spring.profiles.include")));
        }
        return profiles;
    }

    private String[] getProfilesForValue(Object property) {
        String value = property == null ? null : property.toString();
        return property == null ? new String[]{} : StringUtils.tokenizeToStringArray(value, ",");
    }
}

