/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.ReactiveWebServerInitializedEvent;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContextException;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;

public class ReactiveWebServerApplicationContext
extends GenericReactiveWebApplicationContext
implements ConfigurableWebServerApplicationContext {
    private volatile WebServer webServer;
    private String serverNamespace;

    public ReactiveWebServerApplicationContext() {
    }

    public ReactiveWebServerApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            this.stopAndReleaseReactiveWebServer();
            throw ex;
        }
    }

    @Override
    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createWebServer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start reactive web server", ex);
        }
    }

    @Override
    protected void finishRefresh() {
        super.finishRefresh();
        WebServer localServer = this.startReactiveWebServer();
        if (localServer != null) {
            this.publishEvent(new ReactiveWebServerInitializedEvent(localServer, this));
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
        this.stopAndReleaseReactiveWebServer();
    }

    private void createWebServer() {
        WebServer localServer = this.webServer;
        if (localServer == null) {
            this.webServer = this.getWebServerFactory().getWebServer(this.getHttpHandler());
        }
        this.initPropertySources();
    }

    @Override
    public WebServer getWebServer() {
        return this.webServer;
    }

    protected ReactiveWebServerFactory getWebServerFactory() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(ReactiveWebServerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing ReactiveWebServerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple ReactiveWebServerFactory beans : " + StringUtils.arrayToCommaDelimitedString(beanNames));
        }
        return this.getBeanFactory().getBean(beanNames[0], ReactiveWebServerFactory.class);
    }

    protected HttpHandler getHttpHandler() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(HttpHandler.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing HttpHandler bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple HttpHandler beans : " + StringUtils.arrayToCommaDelimitedString(beanNames));
        }
        return this.getBeanFactory().getBean(beanNames[0], HttpHandler.class);
    }

    private WebServer startReactiveWebServer() {
        WebServer localServer = this.webServer;
        if (localServer != null) {
            localServer.start();
        }
        return localServer;
    }

    private void stopAndReleaseReactiveWebServer() {
        WebServer localServer = this.webServer;
        if (localServer != null) {
            try {
                localServer.stop();
                this.webServer = null;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    public String getServerNamespace() {
        return this.serverNamespace;
    }

    @Override
    public void setServerNamespace(String serverNamespace) {
        this.serverNamespace = serverNamespace;
    }
}

