/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.htmlunit;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.MalformedURLException;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class LocalHostWebClient
extends WebClient {
    private final Environment environment;

    public LocalHostWebClient(Environment environment2) {
        Assert.notNull((Object)environment2, "Environment must not be null");
        this.environment = environment2;
    }

    public <P extends Page> P getPage(String url) throws IOException, FailingHttpStatusCodeException, MalformedURLException {
        if (url.startsWith("/")) {
            String port = this.environment.getProperty("local.server.port", "8080");
            url = "http://localhost:" + port + url;
        }
        return (P)super.getPage(url);
    }
}

