/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.boot.test.context.ImportsContextCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ImportsContextCustomizerFactory
implements ContextCustomizerFactory {
    ImportsContextCustomizerFactory() {
    }

    @Override
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (AnnotatedElementUtils.findMergedAnnotation(testClass, Import.class) != null) {
            this.assertHasNoBeanMethods(testClass);
            return new ImportsContextCustomizer(testClass);
        }
        return null;
    }

    private void assertHasNoBeanMethods(Class<?> testClass) {
        ReflectionUtils.doWithMethods(testClass, this::assertHasNoBeanMethods);
    }

    private void assertHasNoBeanMethods(Method method) {
        Assert.state(!AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, Bean.class), "Test classes cannot include @Bean methods");
    }
}

