/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.web.context.WebApplicationContext;

@Configuration
@ConditionalOnClass(value={SecurityMockMvcRequestPostProcessors.class})
class MockMvcSecurityConfiguration {
    private static final String DEFAULT_SECURITY_FILTER_NAME = "springSecurityFilterChain";

    MockMvcSecurityConfiguration() {
    }

    @Bean
    @ConditionalOnBean(name={"springSecurityFilterChain"})
    public SecurityMockMvcBuilderCustomizer securityMockMvcBuilderCustomizer() {
        return new SecurityMockMvcBuilderCustomizer();
    }

    class SecurityMockMvcBuilderCustomizer
    implements MockMvcBuilderCustomizer {
        SecurityMockMvcBuilderCustomizer() {
        }

        @Override
        public void customize(ConfigurableMockMvcBuilder<?> builder) {
            builder.apply(new MockMvcConfigurerAdapter(){

                @Override
                public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
                    return SecurityMockMvcRequestPostProcessors.testSecurityContext();
                }
            });
        }
    }
}

