/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportMessage;
import org.springframework.boot.test.context.DefaultTestExecutionListenersPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class SpringBootDependencyInjectionTestExecutionListener
extends DependencyInjectionTestExecutionListener {
    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        try {
            super.prepareTestInstance(testContext);
        }
        catch (Exception ex) {
            this.outputConditionEvaluationReport(testContext);
            throw ex;
        }
    }

    private void outputConditionEvaluationReport(TestContext testContext) {
        try {
            ApplicationContext context = testContext.getApplicationContext();
            if (context instanceof ConfigurableApplicationContext) {
                ConditionEvaluationReport report = ConditionEvaluationReport.get(((ConfigurableApplicationContext)context).getBeanFactory());
                System.err.println(new ConditionEvaluationReportMessage(report));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class PostProcessor
    implements DefaultTestExecutionListenersPostProcessor {
        PostProcessor() {
        }

        @Override
        public Set<Class<? extends TestExecutionListener>> postProcessDefaultTestExecutionListeners(Set<Class<? extends TestExecutionListener>> listeners) {
            LinkedHashSet<Class<? extends TestExecutionListener>> updated = new LinkedHashSet<Class<? extends TestExecutionListener>>(listeners.size());
            for (Class<? extends TestExecutionListener> listener : listeners) {
                updated.add(listener.equals(DependencyInjectionTestExecutionListener.class) ? SpringBootDependencyInjectionTestExecutionListener.class : listener);
            }
            return updated;
        }
    }
}

