/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.reactive;

import java.util.function.Supplier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ApplicationContextServerWebExchangeMatcher<C>
implements ServerWebExchangeMatcher {
    private final Class<? extends C> contextClass;
    private volatile Supplier<C> context;
    private final Object contextLock = new Object();

    public ApplicationContextServerWebExchangeMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, "Context class must not be null");
        this.contextClass = contextClass;
    }

    @Override
    public final Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
        return this.matches(exchange2, this.getContext(exchange2));
    }

    protected abstract Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange var1, Supplier<C> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Supplier<C> getContext(ServerWebExchange exchange2) {
        if (this.context == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.context == null) {
                    this.context = this.createContext(exchange2);
                    this.initialized(this.context);
                }
            }
        }
        return this.context;
    }

    protected void initialized(Supplier<C> context) {
    }

    private Supplier<C> createContext(ServerWebExchange exchange2) {
        ApplicationContext context = exchange2.getApplicationContext();
        Assert.state(context != null, "No WebApplicationContext found.");
        if (this.contextClass.isInstance(context)) {
            return () -> context;
        }
        return () -> context.getBean(this.contextClass);
    }
}

