/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.IndexedElementsBinder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class CollectionBinder
extends IndexedElementsBinder<Collection<Object>> {
    CollectionBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected Object bindAggregate(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder) {
        Class<List> collectionType = target.getValue() != null ? List.class : target.getType().resolve(Object.class);
        ResolvableType aggregateType = ResolvableType.forClassWithGenerics(List.class, target.getType().asCollection().getGenerics());
        ResolvableType elementType = target.getType().asCollection().getGeneric(new int[0]);
        IndexedElementsBinder.IndexedCollectionSupplier result = new IndexedElementsBinder.IndexedCollectionSupplier(() -> CollectionFactory.createCollection(collectionType, 0));
        this.bindIndexed(name, target, elementBinder, aggregateType, elementType, result);
        if (result.wasSupplied()) {
            return result.get();
        }
        return null;
    }

    @Override
    protected Collection<Object> merge(Supplier<?> existing, Collection<Object> additional) {
        Collection existingCollection = (Collection)existing.get();
        if (existingCollection == null) {
            return additional;
        }
        try {
            existingCollection.clear();
            existingCollection.addAll(additional);
            return this.copyIfPossible(existingCollection);
        }
        catch (UnsupportedOperationException ex) {
            return this.createNewCollection(additional);
        }
    }

    private Collection<Object> copyIfPossible(Collection<Object> collection) {
        try {
            return this.createNewCollection(collection);
        }
        catch (Exception ex) {
            return collection;
        }
    }

    private Collection<Object> createNewCollection(Collection<Object> collection) {
        Collection<Object> result = CollectionFactory.createCollection(collection.getClass(), collection.size());
        result.addAll(collection);
        return result;
    }
}

