/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.template;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.springframework.util.MimeType;

public abstract class AbstractViewResolverProperties {
    private static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf("text/html");
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private boolean enabled = true;
    private boolean cache;
    private MimeType contentType = DEFAULT_CONTENT_TYPE;
    private Charset charset = DEFAULT_CHARSET;
    private String[] viewNames;
    private boolean checkTemplateLocation = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCheckTemplateLocation(boolean checkTemplateLocation) {
        this.checkTemplateLocation = checkTemplateLocation;
    }

    public boolean isCheckTemplateLocation() {
        return this.checkTemplateLocation;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public MimeType getContentType() {
        if (this.contentType.getCharset() == null) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", this.charset.name());
            parameters.putAll(this.contentType.getParameters());
            return new MimeType(this.contentType, parameters);
        }
        return this.contentType;
    }

    public void setContentType(MimeType contentType) {
        this.contentType = contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getCharsetName() {
        return this.charset != null ? this.charset.name() : null;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

