/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsProvider;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483647)
public class MetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebFluxTagsProvider tagsProvider;
    private final String metricName;

    public MetricsWebFilter(MeterRegistry registry, WebFluxTagsProvider tagsProvider, String metricName) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return chain.filter(exchange2).compose(call -> this.filter(exchange2, (Mono<Void>)call));
    }

    private Publisher<Void> filter(ServerWebExchange exchange2, Mono<Void> call) {
        long start = System.nanoTime();
        ServerHttpResponse response = exchange2.getResponse();
        return call.doOnSuccess(done -> this.success(exchange2, start)).doOnError(cause -> {
            if (response.isCommitted()) {
                this.error(exchange2, start, (Throwable)cause);
            } else {
                response.beforeCommit(() -> {
                    this.error(exchange2, start, (Throwable)cause);
                    return Mono.empty();
                });
            }
        });
    }

    private void success(ServerWebExchange exchange2, long start) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange2, null);
        this.registry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    private void error(ServerWebExchange exchange2, long start, Throwable cause) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange2, cause);
        this.registry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }
}

