/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractHealthIndicator
implements HealthIndicator {
    private static final String NO_MESSAGE = null;
    private static final String DEFAULT_MESSAGE = "Health check failed";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Function<Exception, String> healthCheckFailedMessage;

    protected AbstractHealthIndicator() {
        this(NO_MESSAGE);
    }

    protected AbstractHealthIndicator(String healthCheckFailedMessage) {
        this.healthCheckFailedMessage = ex -> healthCheckFailedMessage;
    }

    protected AbstractHealthIndicator(Function<Exception, String> healthCheckFailedMessage) {
        Assert.notNull(healthCheckFailedMessage, "HealthCheckFailedMessage must not be null");
        this.healthCheckFailedMessage = healthCheckFailedMessage;
    }

    @Override
    public final Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            this.doHealthCheck(builder);
        }
        catch (Exception ex) {
            if (this.logger.isWarnEnabled()) {
                String message = this.healthCheckFailedMessage.apply(ex);
                this.logger.warn(StringUtils.hasText(message) ? message : DEFAULT_MESSAGE, ex);
            }
            builder.down(ex);
        }
        return builder.build();
    }

    protected abstract void doHealthCheck(Health.Builder var1) throws Exception;
}

