/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.net.InetAddress;
import org.springframework.boot.autoconfigure.security.SecurityPrerequisite;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management.server", ignoreUnknownFields=true)
public class ManagementServerProperties
implements SecurityPrerequisite {
    private Integer port;
    private InetAddress address;
    private final Servlet servlet = new Servlet();
    @NestedConfigurationProperty
    private Ssl ssl;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public static class Servlet {
        private String contextPath = "";

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            Assert.notNull((Object)contextPath, "ContextPath must not be null");
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            if (StringUtils.hasText(contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }
    }
}

