/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class ManagementContextConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware {
    private ClassLoader classLoader;

    ManagementContextConfigurationImportSelector() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata metadata) {
        ManagementContextType contextType = (ManagementContextType)((Object)metadata.getAnnotationAttributes(EnableManagementContext.class.getName()).get("value"));
        List<ManagementConfiguration> configurations = this.getConfigurations();
        OrderComparator.sort(configurations);
        ArrayList<String> names = new ArrayList<String>();
        for (ManagementConfiguration configuration : configurations) {
            if (configuration.getContextType() != ManagementContextType.ANY && configuration.getContextType() != contextType) continue;
            names.add(configuration.getClassName());
        }
        return StringUtils.toStringArray(names);
    }

    private List<ManagementConfiguration> getConfigurations() {
        SimpleMetadataReaderFactory readerFactory = new SimpleMetadataReaderFactory(this.classLoader);
        ArrayList<ManagementConfiguration> configurations = new ArrayList<ManagementConfiguration>();
        for (String className : this.loadFactoryNames()) {
            this.addConfiguration(readerFactory, configurations, className);
        }
        return configurations;
    }

    private void addConfiguration(SimpleMetadataReaderFactory readerFactory, List<ManagementConfiguration> configurations, String className) {
        try {
            MetadataReader metadataReader = readerFactory.getMetadataReader(className);
            configurations.add(new ManagementConfiguration(metadataReader));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read annotation metadata for '" + className + "'", ex);
        }
    }

    protected List<String> loadFactoryNames() {
        return SpringFactoriesLoader.loadFactoryNames(ManagementContextConfiguration.class, this.classLoader);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static final class ManagementConfiguration
    implements Ordered {
        private final String className;
        private final int order;
        private final ManagementContextType contextType;

        ManagementConfiguration(MetadataReader metadataReader) {
            AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
            this.order = this.readOrder(annotationMetadata);
            this.className = metadataReader.getClassMetadata().getClassName();
            this.contextType = this.readContextType(annotationMetadata);
        }

        private ManagementContextType readContextType(AnnotationMetadata annotationMetadata) {
            Map<String, Object> annotationAttributes = annotationMetadata.getAnnotationAttributes(ManagementContextConfiguration.class.getName());
            return annotationAttributes != null ? (ManagementContextType)((Object)annotationAttributes.get("value")) : ManagementContextType.ANY;
        }

        private int readOrder(AnnotationMetadata annotationMetadata) {
            Map<String, Object> attributes = annotationMetadata.getAnnotationAttributes(Order.class.getName());
            Integer order = attributes != null ? (Integer)attributes.get("value") : null;
            return order != null ? order : Integer.MAX_VALUE;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        public ManagementContextType getContextType() {
            return this.contextType;
        }
    }
}

