/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.health.CompositeHealthIndicatorFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

final class HealthIndicatorBeansComposite {
    private HealthIndicatorBeansComposite() {
    }

    public static HealthIndicator get(ApplicationContext applicationContext) {
        HealthAggregator healthAggregator = HealthIndicatorBeansComposite.getHealthAggregator(applicationContext);
        LinkedHashMap<String, HealthIndicator> indicators = new LinkedHashMap<String, HealthIndicator>();
        indicators.putAll(applicationContext.getBeansOfType(HealthIndicator.class));
        if (ClassUtils.isPresent("reactor.core.publisher.Flux", null)) {
            new ReactiveHealthIndicators().get(applicationContext).forEach(indicators::putIfAbsent);
        }
        CompositeHealthIndicatorFactory factory = new CompositeHealthIndicatorFactory();
        return factory.createHealthIndicator(healthAggregator, indicators);
    }

    private static HealthAggregator getHealthAggregator(ApplicationContext applicationContext) {
        try {
            return applicationContext.getBean(HealthAggregator.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return new OrderedHealthAggregator();
        }
    }

    private static class ReactiveHealthIndicators {
        private ReactiveHealthIndicators() {
        }

        public Map<String, HealthIndicator> get(ApplicationContext applicationContext) {
            LinkedHashMap<String, HealthIndicator> indicators = new LinkedHashMap<String, HealthIndicator>();
            applicationContext.getBeansOfType(ReactiveHealthIndicator.class).forEach((name, indicator) -> indicators.put((String)name, this.adapt((ReactiveHealthIndicator)indicator)));
            return indicators;
        }

        private HealthIndicator adapt(ReactiveHealthIndicator indicator) {
            return () -> (Health)indicator.health().block();
        }
    }
}

